/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.physical.impl.scan;

import org.apache.drill.common.exceptions.UserException;
import org.apache.drill.exec.physical.impl.scan.RowBatchReader;
import org.apache.drill.exec.physical.impl.scan.ScanOperatorExec;
import org.apache.drill.exec.record.VectorContainer;
import org.apache.drill.exec.vector.accessor.InvalidConversionError;
import org.apache.drill.exec.vector.accessor.UnsupportedConversionError;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ReaderState {
    static final Logger logger = LoggerFactory.getLogger(ReaderState.class);
    final ScanOperatorExec scanOp;
    private final RowBatchReader reader;
    private State state = State.START;
    private VectorContainer lookahead;

    public ReaderState(ScanOperatorExec scanOp, RowBatchReader reader) {
        this.scanOp = scanOp;
        this.reader = reader;
    }

    boolean open() {
        try {
            if (!this.reader.open()) {
                this.state = State.EOF;
                return false;
            }
        }
        catch (UserException e) {
            throw e;
        }
        catch (UnsupportedConversionError e) {
            throw UserException.validationError(e).message("Invalid runtime type conversion", new Object[0]).build(logger);
        }
        catch (Throwable t) {
            throw UserException.executionError(t).addContext("Open failed for reader", this.reader.name()).build(logger);
        }
        this.state = State.ACTIVE;
        return true;
    }

    protected boolean buildSchema() {
        if (this.reader.defineSchema()) {
            this.scanOp.containerAccessor.setSchema(this.reader.output());
            return true;
        }
        if (!this.next()) {
            return false;
        }
        VectorContainer container = this.reader.output();
        if (container.getRecordCount() == 0) {
            return true;
        }
        assert (this.lookahead == null);
        this.lookahead = new VectorContainer(this.scanOp.context.getAllocator(), this.scanOp.containerAccessor.schema());
        this.lookahead.setRecordCount(0);
        this.lookahead.exchange(this.scanOp.containerAccessor.container());
        this.state = this.state == State.EOF ? State.LOOK_AHEAD_WITH_EOF : State.LOOK_AHEAD;
        return true;
    }

    protected boolean next() {
        switch (this.state) {
            case LOOK_AHEAD: 
            case LOOK_AHEAD_WITH_EOF: {
                assert (this.lookahead != null);
                this.lookahead.exchange(this.scanOp.containerAccessor.container());
                assert (this.lookahead.getRecordCount() == 0);
                this.lookahead = null;
                this.state = this.state == State.LOOK_AHEAD_WITH_EOF ? State.EOF : State.ACTIVE;
                return true;
            }
            case ACTIVE: {
                return this.readBatch();
            }
            case EOF: {
                return false;
            }
        }
        throw new IllegalStateException("Unexpected state: " + (Object)((Object)this.state));
    }

    private boolean readBatch() {
        boolean more;
        try {
            more = this.reader.next();
        }
        catch (UserException e) {
            throw e;
        }
        catch (InvalidConversionError e) {
            throw UserException.unsupportedError(e).message("Invalid data value for automatic type conversion", new Object[0]).addContext("Read failed for reader", this.reader.name()).build(logger);
        }
        catch (Throwable t) {
            throw UserException.executionError(t).addContext("Read failed for reader", this.reader.name()).build(logger);
        }
        VectorContainer output = this.reader.output();
        if (!more) {
            this.state = State.EOF;
            if (output == null) {
                return false;
            }
            if (output.getRecordCount() == 0) {
                if (this.scanOp.containerAccessor.schemaVersion() == 0 && this.reader.schemaVersion() > 0) {
                    this.scanOp.containerAccessor.setSchema(output);
                }
                output.zeroVectors();
                return false;
            }
        }
        this.scanOp.containerAccessor.addBatch(output);
        return true;
    }

    void close() {
        if (this.state == State.CLOSED) {
            return;
        }
        try {
            this.reader.close();
        }
        catch (UserException e) {
            throw e;
        }
        catch (Throwable t) {
            throw UserException.executionError(t).addContext("Close failed for reader", this.reader.name()).build(logger);
        }
        finally {
            if (this.lookahead != null) {
                this.lookahead.clear();
                this.lookahead = null;
            }
            this.state = State.CLOSED;
        }
    }

    private static enum State {
        START,
        LOOK_AHEAD,
        LOOK_AHEAD_WITH_EOF,
        ACTIVE,
        EOF,
        CLOSED;

    }
}

