/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.physical.impl.scan;

import org.apache.drill.common.exceptions.ExecutionSetupException;
import org.apache.drill.common.exceptions.UserException;
import org.apache.drill.exec.ops.OperatorContext;
import org.apache.drill.exec.physical.impl.protocol.BatchAccessor;
import org.apache.drill.exec.physical.impl.protocol.OperatorExec;
import org.apache.drill.exec.physical.impl.protocol.VectorContainerAccessor;
import org.apache.drill.exec.physical.impl.scan.ReaderState;
import org.apache.drill.exec.physical.impl.scan.RowBatchReader;
import org.apache.drill.exec.physical.impl.scan.ScanOperatorEvents;
import org.apache.drill.shaded.guava.com.google.common.annotations.VisibleForTesting;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ScanOperatorExec
implements OperatorExec {
    static final Logger logger = LoggerFactory.getLogger(ScanOperatorExec.class);
    private final ScanOperatorEvents factory;
    private final boolean allowEmptyResult;
    protected final VectorContainerAccessor containerAccessor = new VectorContainerAccessor();
    private State state = State.START;
    protected OperatorContext context;
    private int readerCount;
    private ReaderState readerState;

    public ScanOperatorExec(ScanOperatorEvents factory, boolean allowEmptyResult) {
        this.factory = factory;
        this.allowEmptyResult = allowEmptyResult;
    }

    @Override
    public void bind(OperatorContext context) {
        this.context = context;
        this.factory.bind(context);
    }

    @Override
    public BatchAccessor batchAccessor() {
        return this.containerAccessor;
    }

    @VisibleForTesting
    public OperatorContext context() {
        return this.context;
    }

    @Override
    public boolean buildSchema() {
        assert (this.state == State.START);
        this.nextAction(true);
        if (this.state != State.END) {
            return true;
        }
        if (this.readerCount == 0) {
            throw UserException.executionError(new ExecutionSetupException("A scan batch must contain at least one reader.")).build(logger);
        }
        return false;
    }

    @Override
    public boolean next() {
        try {
            switch (this.state) {
                case READER: 
                case START: {
                    this.nextAction(false);
                    return this.state != State.END;
                }
                case EMPTY: {
                    this.state = State.END;
                    return false;
                }
                case END: {
                    return false;
                }
            }
            throw new IllegalStateException("Unexpected state: " + (Object)((Object)this.state));
        }
        catch (Throwable t) {
            this.state = State.FAILED;
            throw t;
        }
    }

    private void nextAction(boolean readSchema) {
        while (true) {
            if (this.readerState != null) {
                boolean hasData = readSchema ? this.readerState.buildSchema() : this.readerState.next();
                if (hasData) break;
                this.closeReader();
            }
            if (!this.nextReader()) {
                this.finalizeResults();
                return;
            }
            this.state = State.READER;
            if (this.readerState.open()) continue;
            this.closeReader();
        }
    }

    private void finalizeResults() {
        if (this.allowEmptyResult && this.containerAccessor.batchCount() == 0 && this.containerAccessor.schemaVersion() > 0) {
            this.containerAccessor.container().setEmpty();
            this.state = State.EMPTY;
        } else {
            if (this.containerAccessor.container() != null) {
                this.containerAccessor.container().setRecordCount(0);
            }
            this.state = State.END;
        }
    }

    private boolean nextReader() {
        RowBatchReader reader = this.factory.nextReader();
        if (reader == null) {
            return false;
        }
        ++this.readerCount;
        this.readerState = new ReaderState(this, reader);
        return true;
    }

    private void closeReader() {
        try {
            this.readerState.close();
        }
        finally {
            this.readerState = null;
        }
    }

    @Override
    public void cancel() {
        switch (this.state) {
            case FAILED: 
            case CLOSED: {
                break;
            }
            default: {
                this.state = State.FAILED;
                this.closeAll();
            }
        }
    }

    @Override
    public void close() {
        if (this.state == State.CLOSED) {
            return;
        }
        this.closeAll();
    }

    private void closeAll() {
        try {
            if (this.readerState != null) {
                this.closeReader();
            }
        }
        finally {
            this.factory.close();
            this.state = State.CLOSED;
        }
    }

    private static enum State {
        START,
        READER,
        EMPTY,
        END,
        FAILED,
        CLOSED;

    }
}

