/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.physical.impl.scan.columns;

import org.apache.drill.common.exceptions.UserException;
import org.apache.drill.exec.physical.impl.scan.columns.UnresolvedColumnsArrayColumn;
import org.apache.drill.exec.physical.impl.scan.project.AbstractUnresolvedColumn;
import org.apache.drill.exec.physical.impl.scan.project.ColumnProjection;
import org.apache.drill.exec.physical.impl.scan.project.ScanLevelProjection;
import org.apache.drill.exec.physical.resultSet.project.RequestedColumn;
import org.apache.drill.exec.physical.resultSet.project.RequestedColumnImpl;
import org.apache.drill.shaded.guava.com.google.common.annotations.VisibleForTesting;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ColumnsArrayParser
implements ScanLevelProjection.ScanProjectionParser {
    private static final Logger logger = LoggerFactory.getLogger(ColumnsArrayParser.class);
    private final boolean requireColumnsArray;
    private final boolean allowOtherCols;
    private ScanLevelProjection builder;
    private UnresolvedColumnsArrayColumn columnsArrayCol;

    public ColumnsArrayParser(boolean requireColumnsArray, boolean allowOtherCols) {
        this.requireColumnsArray = requireColumnsArray;
        this.allowOtherCols = allowOtherCols;
    }

    @VisibleForTesting
    public ColumnsArrayParser(boolean requireColumnsArray) {
        this(requireColumnsArray, false);
    }

    @Override
    public void bind(ScanLevelProjection builder) {
        this.builder = builder;
    }

    @Override
    public boolean parse(RequestedColumn inCol) {
        int maxIndex;
        if (!this.requireColumnsArray && !this.allowOtherCols) {
            if (inCol.isArray()) {
                throw UserException.validationError().message("Unexpected `columns`[x]; columns array not enabled", new Object[0]).addContext(this.builder.context()).build(logger);
            }
            return false;
        }
        if (inCol.isWildcard()) {
            this.createColumnsCol(new RequestedColumnImpl(this.builder.rootProjection(), "columns"));
            return true;
        }
        if (!inCol.nameEquals("columns")) {
            return false;
        }
        if (inCol.isTuple() && !this.allowOtherCols) {
            throw UserException.validationError().message("Column `%s` has map elements, but must be an array", inCol.name()).addContext(this.builder.context()).build(logger);
        }
        if (inCol.isArray() && (maxIndex = inCol.maxIndex()) > 65536) {
            throw UserException.validationError().message("`columns`[%d] index out of bounds, max supported size is %d", maxIndex, 65536).addContext("Column:", inCol.name()).addContext("Maximum index:", 65536L).addContext("Actual index:", maxIndex).addContext(this.builder.context()).build(logger);
        }
        this.createColumnsCol(inCol);
        return true;
    }

    private void createColumnsCol(RequestedColumn inCol) {
        if (this.columnsArrayCol == null) {
            this.columnsArrayCol = new UnresolvedColumnsArrayColumn(inCol);
            this.builder.addTableColumn(this.columnsArrayCol);
        }
    }

    @Override
    public void validate() {
    }

    @Override
    public void validateColumn(ColumnProjection col) {
        if (col instanceof AbstractUnresolvedColumn.UnresolvedColumn) {
            if (this.columnsArrayCol != null) {
                throw UserException.validationError().message("Cannot select columns[] and other table columns. Column alias incorrectly used in the WHERE clause?", new Object[0]).addContext("Column name", col.name()).addContext(this.builder.context()).build(logger);
            }
            if (this.requireColumnsArray && !this.allowOtherCols) {
                throw UserException.validationError().message("Only `columns` column is allowed. Found: " + col.name(), new Object[0]).addContext(this.builder.context()).build(logger);
            }
        }
    }

    @Override
    public void build() {
    }

    public UnresolvedColumnsArrayColumn columnsArrayCol() {
        return this.columnsArrayCol;
    }
}

