/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.physical.impl.scan.columns;

import org.apache.drill.common.types.TypeProtos;
import org.apache.drill.exec.physical.impl.scan.ScanOperatorEvents;
import org.apache.drill.exec.physical.impl.scan.columns.ColumnsArrayManager;
import org.apache.drill.exec.physical.impl.scan.columns.ColumnsSchemaNegotiator;
import org.apache.drill.exec.physical.impl.scan.file.FileScanFramework;
import org.apache.drill.exec.physical.impl.scan.framework.SchemaNegotiatorImpl;
import org.apache.drill.exec.record.metadata.SchemaBuilder;
import org.apache.drill.exec.record.metadata.TupleMetadata;

public class ColumnsScanFramework
extends FileScanFramework {
    public static final String COLUMNS_COL = "columns";
    protected ColumnsArrayManager columnsArrayManager;

    public ColumnsScanFramework(ColumnsScanBuilder builder) {
        super(builder);
    }

    @Override
    protected void configure() {
        super.configure();
        ColumnsScanBuilder colScanBuilder = (ColumnsScanBuilder)this.builder;
        this.columnsArrayManager = new ColumnsArrayManager(colScanBuilder.requireColumnsArray, colScanBuilder.allowOtherCols);
        this.builder.addParser(this.columnsArrayManager.projectionParser());
        this.builder.addResolver(this.columnsArrayManager.resolver());
    }

    @Override
    protected SchemaNegotiatorImpl newNegotiator() {
        return new ColumnsSchemaNegotiatorImpl(this);
    }

    public static TupleMetadata columnsSchema() {
        return new SchemaBuilder().addArray(COLUMNS_COL, TypeProtos.MinorType.VARCHAR).buildSchema();
    }

    public static class ColumnsScanBuilder
    extends FileScanFramework.FileScanBuilder {
        protected boolean requireColumnsArray;
        protected boolean allowOtherCols;

        public void requireColumnsArray(boolean flag) {
            this.requireColumnsArray = flag;
        }

        public void allowOtherCols(boolean flag) {
            this.allowOtherCols = flag;
        }

        @Override
        public ScanOperatorEvents buildEvents() {
            return new ColumnsScanFramework(this);
        }
    }

    public static class ColumnsSchemaNegotiatorImpl
    extends FileScanFramework.FileSchemaNegotiatorImpl
    implements ColumnsSchemaNegotiator {
        public ColumnsSchemaNegotiatorImpl(ColumnsScanFramework framework) {
            super(framework);
        }

        private ColumnsScanFramework framework() {
            return (ColumnsScanFramework)this.framework;
        }

        @Override
        public boolean columnsArrayProjected() {
            return this.framework().columnsArrayManager.hasColumnsArrayColumn();
        }

        @Override
        public boolean[] projectedIndexes() {
            return this.framework().columnsArrayManager.elementProjection();
        }
    }
}

