/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.physical.impl.scan.convert;

import java.util.Map;
import org.apache.drill.common.types.BooleanType;
import org.apache.drill.exec.physical.impl.scan.convert.AbstractConvertFromString;
import org.apache.drill.exec.vector.accessor.InvalidConversionError;
import org.apache.drill.exec.vector.accessor.ScalarWriter;

public class ConvertStringToBoolean
extends AbstractConvertFromString {
    public ConvertStringToBoolean(ScalarWriter baseWriter, Map<String, String> properties) {
        super(baseWriter, properties);
    }

    @Override
    public void setString(String value) {
        String prepared = (String)this.prepare.apply(value);
        if (prepared == null) {
            return;
        }
        try {
            this.baseWriter.setBoolean(BooleanType.fromString(prepared));
        }
        catch (NumberFormatException e) {
            throw InvalidConversionError.writeError(this.schema(), value, e);
        }
    }
}

