/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.physical.impl.scan.convert;

import java.time.LocalTime;
import java.time.format.DateTimeFormatter;
import java.util.Map;
import org.apache.drill.exec.physical.impl.scan.convert.AbstractConvertFromString;
import org.apache.drill.exec.vector.accessor.InvalidConversionError;
import org.apache.drill.exec.vector.accessor.ScalarWriter;

public class ConvertStringToTime
extends AbstractConvertFromString {
    private final DateTimeFormatter dateTimeFormatter;

    public ConvertStringToTime(ScalarWriter baseWriter, Map<String, String> properties) {
        super(baseWriter, properties);
        this.dateTimeFormatter = baseWriter.schema().dateTimeFormatter();
    }

    @Override
    public void setString(String value) {
        String prepared = (String)this.prepare.apply(value);
        if (prepared == null) {
            return;
        }
        try {
            this.baseWriter.setTime(LocalTime.parse(prepared, this.dateTimeFormatter));
        }
        catch (Exception e) {
            throw InvalidConversionError.writeError(this.schema(), value, e);
        }
    }
}

