/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.physical.impl.scan.convert;

import java.lang.reflect.Constructor;
import java.util.HashMap;
import java.util.Map;
import org.apache.drill.common.types.TypeProtos;
import org.apache.drill.exec.physical.impl.scan.convert.ConvertBooleanToString;
import org.apache.drill.exec.physical.impl.scan.convert.ConvertDateToString;
import org.apache.drill.exec.physical.impl.scan.convert.ConvertDoubleToDecimal;
import org.apache.drill.exec.physical.impl.scan.convert.ConvertDoubleToString;
import org.apache.drill.exec.physical.impl.scan.convert.ConvertFloatToDecimal;
import org.apache.drill.exec.physical.impl.scan.convert.ConvertIntToDecimal;
import org.apache.drill.exec.physical.impl.scan.convert.ConvertIntToString;
import org.apache.drill.exec.physical.impl.scan.convert.ConvertIntervalToString;
import org.apache.drill.exec.physical.impl.scan.convert.ConvertLongToDecimal;
import org.apache.drill.exec.physical.impl.scan.convert.ConvertLongToString;
import org.apache.drill.exec.physical.impl.scan.convert.ConvertStringToBoolean;
import org.apache.drill.exec.physical.impl.scan.convert.ConvertStringToDate;
import org.apache.drill.exec.physical.impl.scan.convert.ConvertStringToDecimal;
import org.apache.drill.exec.physical.impl.scan.convert.ConvertStringToDouble;
import org.apache.drill.exec.physical.impl.scan.convert.ConvertStringToInt;
import org.apache.drill.exec.physical.impl.scan.convert.ConvertStringToInterval;
import org.apache.drill.exec.physical.impl.scan.convert.ConvertStringToLong;
import org.apache.drill.exec.physical.impl.scan.convert.ConvertStringToTime;
import org.apache.drill.exec.physical.impl.scan.convert.ConvertStringToTimeStamp;
import org.apache.drill.exec.physical.impl.scan.convert.ConvertTimeStampToString;
import org.apache.drill.exec.physical.impl.scan.convert.ConvertTimeToString;
import org.apache.drill.exec.physical.impl.scan.convert.DirectConverter;
import org.apache.drill.exec.record.metadata.ColumnMetadata;
import org.apache.drill.exec.record.metadata.TupleMetadata;
import org.apache.drill.exec.vector.accessor.ScalarWriter;
import org.apache.drill.exec.vector.accessor.ValueWriter;

public class StandardConversions {
    public static final ConversionDefn IMPLICIT = new ConversionDefn(ConversionType.IMPLICIT);
    public static final ConversionDefn IMPLICIT_UNSAFE = new ConversionDefn(ConversionType.IMPLICIT_UNSAFE);
    public static final ConversionDefn EXPLICIT = new ConversionDefn(ConversionType.EXPLICIT);
    private final Map<String, String> properties;

    private StandardConversions(Map<String, String> properties) {
        this.properties = properties;
    }

    public static Builder builder() {
        return new Builder();
    }

    private static Map<String, String> mergeProperties(Map<String, String> properties, Map<String, String> specificProps) {
        if (properties == null) {
            return specificProps;
        }
        if (specificProps == null) {
            return properties;
        }
        HashMap<String, String> merged = new HashMap<String, String>();
        merged.putAll(properties);
        merged.putAll(specificProps);
        return merged;
    }

    private Map<String, String> mergeProperties(Map<String, String> specificProps) {
        return StandardConversions.mergeProperties(this.properties, specificProps);
    }

    public DirectConverter newInstance(Class<? extends DirectConverter> conversionClass, ScalarWriter baseWriter, Map<String, String> properties) {
        try {
            Constructor<? extends DirectConverter> ctor = conversionClass.getDeclaredConstructor(ScalarWriter.class, Map.class);
            return ctor.newInstance(baseWriter, this.mergeProperties(properties));
        }
        catch (ReflectiveOperationException e) {
            if (e.getCause() instanceof IllegalArgumentException) {
                throw new IllegalArgumentException(e.getCause());
            }
            return this.newInstance(conversionClass, baseWriter);
        }
    }

    public DirectConverter newInstance(Class<? extends DirectConverter> conversionClass, ScalarWriter baseWriter) {
        try {
            Constructor<? extends DirectConverter> ctor = conversionClass.getDeclaredConstructor(ScalarWriter.class);
            return ctor.newInstance(baseWriter);
        }
        catch (ReflectiveOperationException e) {
            throw new IllegalStateException(e);
        }
    }

    public ConversionDefn analyze(ColumnMetadata inputSchema, ColumnMetadata outputSchema) {
        return this.analyze(inputSchema.type(), outputSchema);
    }

    public ConversionDefn analyze(TypeProtos.MinorType inputType, ColumnMetadata outputSchema) {
        if (inputType == outputSchema.type()) {
            return new ConversionDefn(ConversionType.NONE);
        }
        switch (inputType) {
            case VARCHAR: {
                return new ConversionDefn(this.convertFromVarchar(outputSchema));
            }
            case BIT: {
                switch (outputSchema.type()) {
                    case TINYINT: 
                    case SMALLINT: 
                    case INT: {
                        return IMPLICIT;
                    }
                    case VARCHAR: {
                        return new ConversionDefn(ConvertBooleanToString.class);
                    }
                }
                break;
            }
            case TINYINT: {
                switch (outputSchema.type()) {
                    case SMALLINT: 
                    case INT: 
                    case BIGINT: 
                    case FLOAT4: 
                    case FLOAT8: {
                        return IMPLICIT;
                    }
                    case VARDECIMAL: {
                        return new ConversionDefn(ConvertIntToDecimal.class);
                    }
                    case VARCHAR: {
                        return new ConversionDefn(ConvertIntToString.class);
                    }
                }
                break;
            }
            case SMALLINT: {
                switch (outputSchema.type()) {
                    case TINYINT: {
                        return IMPLICIT_UNSAFE;
                    }
                    case INT: 
                    case BIGINT: 
                    case FLOAT4: 
                    case FLOAT8: {
                        return IMPLICIT;
                    }
                    case VARDECIMAL: {
                        return new ConversionDefn(ConvertIntToDecimal.class);
                    }
                    case VARCHAR: {
                        return new ConversionDefn(ConvertIntToString.class);
                    }
                }
                break;
            }
            case INT: {
                switch (outputSchema.type()) {
                    case TINYINT: 
                    case SMALLINT: {
                        return IMPLICIT_UNSAFE;
                    }
                    case BIGINT: 
                    case FLOAT4: 
                    case FLOAT8: 
                    case TIME: {
                        return IMPLICIT;
                    }
                    case VARDECIMAL: {
                        return new ConversionDefn(ConvertIntToDecimal.class);
                    }
                    case VARCHAR: {
                        return new ConversionDefn(ConvertIntToString.class);
                    }
                }
                break;
            }
            case BIGINT: {
                switch (outputSchema.type()) {
                    case TINYINT: 
                    case SMALLINT: 
                    case INT: {
                        return IMPLICIT_UNSAFE;
                    }
                    case FLOAT4: 
                    case FLOAT8: 
                    case DATE: 
                    case TIMESTAMP: {
                        return IMPLICIT;
                    }
                    case VARDECIMAL: {
                        return new ConversionDefn(ConvertLongToDecimal.class);
                    }
                    case VARCHAR: {
                        return new ConversionDefn(ConvertLongToString.class);
                    }
                }
                break;
            }
            case FLOAT4: {
                switch (outputSchema.type()) {
                    case TINYINT: 
                    case SMALLINT: 
                    case INT: 
                    case BIGINT: {
                        return IMPLICIT_UNSAFE;
                    }
                    case FLOAT8: {
                        return IMPLICIT;
                    }
                    case VARDECIMAL: {
                        return new ConversionDefn(ConvertFloatToDecimal.class);
                    }
                    case VARCHAR: {
                        return new ConversionDefn(ConvertDoubleToString.class);
                    }
                }
                break;
            }
            case FLOAT8: {
                switch (outputSchema.type()) {
                    case TINYINT: 
                    case SMALLINT: 
                    case INT: 
                    case BIGINT: 
                    case FLOAT4: {
                        return IMPLICIT_UNSAFE;
                    }
                    case VARDECIMAL: {
                        return new ConversionDefn(ConvertDoubleToDecimal.class);
                    }
                    case VARCHAR: {
                        return new ConversionDefn(ConvertDoubleToString.class);
                    }
                }
                break;
            }
            case DATE: {
                switch (outputSchema.type()) {
                    case BIGINT: {
                        return IMPLICIT;
                    }
                    case VARCHAR: {
                        return new ConversionDefn(ConvertDateToString.class);
                    }
                }
                break;
            }
            case TIME: {
                switch (outputSchema.type()) {
                    case INT: {
                        return IMPLICIT;
                    }
                    case VARCHAR: {
                        return new ConversionDefn(ConvertTimeToString.class);
                    }
                }
                break;
            }
            case TIMESTAMP: {
                switch (outputSchema.type()) {
                    case BIGINT: {
                        return IMPLICIT;
                    }
                    case VARCHAR: {
                        return new ConversionDefn(ConvertTimeStampToString.class);
                    }
                }
                break;
            }
            case INTERVAL: 
            case INTERVALYEAR: 
            case INTERVALDAY: {
                switch (outputSchema.type()) {
                    case VARCHAR: {
                        return new ConversionDefn(ConvertIntervalToString.class);
                    }
                }
                break;
            }
        }
        return EXPLICIT;
    }

    public Class<? extends DirectConverter> convertFromVarchar(ColumnMetadata outputDefn) {
        switch (outputDefn.type()) {
            case BIT: {
                return ConvertStringToBoolean.class;
            }
            case TINYINT: 
            case SMALLINT: 
            case INT: 
            case UINT1: 
            case UINT2: {
                return ConvertStringToInt.class;
            }
            case BIGINT: {
                return ConvertStringToLong.class;
            }
            case FLOAT4: 
            case FLOAT8: {
                return ConvertStringToDouble.class;
            }
            case DATE: {
                return ConvertStringToDate.class;
            }
            case TIME: {
                return ConvertStringToTime.class;
            }
            case TIMESTAMP: {
                return ConvertStringToTimeStamp.class;
            }
            case INTERVAL: 
            case INTERVALYEAR: 
            case INTERVALDAY: {
                return ConvertStringToInterval.class;
            }
            case VARDECIMAL: {
                return ConvertStringToDecimal.class;
            }
        }
        return null;
    }

    public ValueWriter converterFor(ScalarWriter scalarWriter, TypeProtos.MinorType inputType, Map<String, String> columnProps) {
        ConversionDefn defn = this.analyze(inputType, scalarWriter.schema());
        switch (defn.type) {
            case EXPLICIT: {
                if (defn.conversionClass != null) {
                    return this.newInstance(defn.conversionClass, scalarWriter, columnProps);
                }
                return null;
            }
            case IMPLICIT: 
            case IMPLICIT_UNSAFE: {
                return this.newInstance(defn.conversionClass, scalarWriter, columnProps);
            }
        }
        return scalarWriter;
    }

    public ValueWriter converterFor(ScalarWriter scalarWriter, TypeProtos.MinorType inputType) {
        return this.converterFor(scalarWriter, inputType, null);
    }

    public ValueWriter converterFor(ScalarWriter scalarWriter, ColumnMetadata inputSchema) {
        return this.converterFor(scalarWriter, inputSchema.type(), inputSchema.hasProperties() ? inputSchema.properties() : null);
    }

    public static class Builder {
        private final Map<String, String> properties = new HashMap<String, String>();

        public Builder withSchema(TupleMetadata providedSchema) {
            if (providedSchema != null && providedSchema.hasProperties()) {
                this.properties.putAll(providedSchema.properties());
            }
            return this;
        }

        public Builder withProperties(Map<String, String> properties) {
            if (properties != null) {
                this.properties.putAll(properties);
            }
            return this;
        }

        public Builder property(String key, String value) {
            if (value == null) {
                this.properties.remove(key);
            } else {
                this.properties.put(key, value);
            }
            return this;
        }

        public Builder blankAs(String value) {
            return this.property("drill.blank-as", value);
        }

        public StandardConversions build() {
            return new StandardConversions(this.properties);
        }
    }

    public static class ConversionDefn {
        public final ConversionType type;
        public final Class<? extends DirectConverter> conversionClass;

        public ConversionDefn(ConversionType type) {
            this.type = type;
            this.conversionClass = null;
        }

        public ConversionDefn(Class<? extends DirectConverter> conversionClass) {
            this.type = ConversionType.EXPLICIT;
            this.conversionClass = conversionClass;
        }
    }

    public static enum ConversionType {
        NONE,
        IMPLICIT,
        IMPLICIT_UNSAFE,
        EXPLICIT;

    }
}

