/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.physical.impl.scan.file;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.drill.common.map.CaseInsensitiveMap;
import org.apache.drill.exec.physical.impl.scan.file.FileMetadata;
import org.apache.drill.exec.physical.impl.scan.file.FileMetadataColumn;
import org.apache.drill.exec.physical.impl.scan.file.FileMetadataColumnDefn;
import org.apache.drill.exec.physical.impl.scan.file.FileMetadataColumnsParser;
import org.apache.drill.exec.physical.impl.scan.file.MetadataColumn;
import org.apache.drill.exec.physical.impl.scan.file.PartitionColumn;
import org.apache.drill.exec.physical.impl.scan.project.ColumnProjection;
import org.apache.drill.exec.physical.impl.scan.project.ConstantColumnLoader;
import org.apache.drill.exec.physical.impl.scan.project.MetadataManager;
import org.apache.drill.exec.physical.impl.scan.project.ReaderLevelProjection;
import org.apache.drill.exec.physical.impl.scan.project.ResolvedTuple;
import org.apache.drill.exec.physical.impl.scan.project.ScanLevelProjection;
import org.apache.drill.exec.physical.impl.scan.project.VectorSource;
import org.apache.drill.exec.physical.resultSet.ResultVectorCache;
import org.apache.drill.exec.record.VectorContainer;
import org.apache.drill.exec.record.metadata.TupleMetadata;
import org.apache.drill.exec.server.options.OptionSet;
import org.apache.drill.exec.store.ColumnExplorer;
import org.apache.drill.exec.vector.ValueVector;
import org.apache.drill.shaded.guava.com.google.common.annotations.VisibleForTesting;
import org.apache.drill.shaded.guava.com.google.common.base.Strings;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;

public class ImplicitColumnManager
implements MetadataManager,
ReaderLevelProjection.ReaderProjectionResolver,
VectorSource {
    public static final int AUTO_PARTITION_DEPTH = -1;
    private final ImplicitColumnOptions options;
    private FileMetadata currentFile;
    private final Path scanRootDir;
    private final int partitionCount;
    protected final String partitionDesignator;
    protected final List<FileMetadataColumnDefn> implicitColDefns = new ArrayList<FileMetadataColumnDefn>();
    protected final Map<String, FileMetadataColumnDefn> fileMetadataColIndex = CaseInsensitiveMap.newHashMap();
    private final FileMetadataColumnsParser parser;
    private ResultVectorCache vectorCache;
    private final List<MetadataColumn> metadataColumns = new ArrayList<MetadataColumn>();
    private ConstantColumnLoader loader;
    private VectorContainer outputContainer;
    private final FileSystem fs;

    public ImplicitColumnManager(OptionSet optionManager, ImplicitColumnOptions config, FileSystem fs) {
        this.options = config;
        this.fs = fs;
        this.partitionDesignator = optionManager.getString("drill.exec.storage.file.partition.column.label");
        for (ColumnExplorer.ImplicitFileColumn e : ColumnExplorer.getImplicitFileColumns()) {
            String colName = optionManager.getString(e.optionName());
            if (Strings.isNullOrEmpty(colName)) continue;
            FileMetadataColumnDefn defn = new FileMetadataColumnDefn(colName, e);
            this.implicitColDefns.add(defn);
            this.fileMetadataColIndex.put(defn.colName, defn);
        }
        this.parser = new FileMetadataColumnsParser(this);
        if (config.rootDir == null || config.files == null) {
            this.scanRootDir = null;
            this.partitionCount = 0;
        } else if (config.files.size() == 1 && config.rootDir.equals(config.files.get(0))) {
            this.scanRootDir = null;
            this.partitionCount = 0;
        } else {
            this.scanRootDir = config.rootDir;
            this.partitionCount = config.partitionCount == -1 ? this.computeMaxPartition(config.files) : this.options.partitionCount;
        }
    }

    public ImplicitColumnManager(OptionSet optionManager, ImplicitColumnOptions config) {
        this(optionManager, config, null);
    }

    protected ImplicitColumnOptions options() {
        return this.options;
    }

    private int computeMaxPartition(List<Path> files) {
        int maxLen = 0;
        for (Path filePath : files) {
            FileMetadata info = this.fileMetadata(filePath);
            maxLen = Math.max(maxLen, info.dirPathLength());
        }
        return maxLen;
    }

    @Override
    public void bind(ResultVectorCache vectorCache) {
        this.vectorCache = vectorCache;
    }

    @Override
    public ScanLevelProjection.ScanProjectionParser projectionParser() {
        return this.parser;
    }

    public FileMetadata fileMetadata(Path filePath) {
        return new FileMetadata(filePath, this.scanRootDir, this.fs);
    }

    public boolean hasImplicitCols() {
        return this.parser.hasImplicitCols();
    }

    public String partitionName(int partition) {
        return this.partitionDesignator + partition;
    }

    public List<FileMetadataColumnDefn> fileMetadataColDefns() {
        return this.implicitColDefns;
    }

    public void startFile(Path filePath) {
        this.currentFile = this.fileMetadata(filePath);
    }

    @Override
    public ReaderLevelProjection.ReaderProjectionResolver resolver() {
        return this;
    }

    @Override
    public void define() {
        assert (this.loader == null);
        if (this.metadataColumns.isEmpty()) {
            return;
        }
        this.loader = new ConstantColumnLoader(this.vectorCache, this.metadataColumns);
    }

    @Override
    public void load(int rowCount) {
        if (this.loader == null) {
            return;
        }
        this.outputContainer = this.loader.load(rowCount);
    }

    @Override
    public void close() {
        this.metadataColumns.clear();
        if (this.loader != null) {
            this.loader.close();
            this.loader = null;
        }
    }

    @Override
    public void startResolution() {
        this.close();
    }

    @Override
    public void endFile() {
        this.currentFile = null;
    }

    @Override
    public boolean resolveColumn(ColumnProjection col, ResolvedTuple tuple, TupleMetadata tableSchema) {
        MetadataColumn outputCol;
        if (col instanceof PartitionColumn) {
            outputCol = ((PartitionColumn)col).resolve(this.currentFile, this, this.metadataColumns.size());
        } else if (col instanceof FileMetadataColumn) {
            outputCol = ((FileMetadataColumn)col).resolve(this.currentFile, this, this.metadataColumns.size());
        } else {
            return false;
        }
        tuple.add(outputCol);
        this.metadataColumns.add(outputCol);
        return true;
    }

    @Override
    public ValueVector vector(int index) {
        return this.outputContainer.getValueVector(index).getValueVector();
    }

    public int partitionCount() {
        return this.partitionCount;
    }

    @VisibleForTesting
    public List<MetadataColumn> metadataColumns() {
        return this.metadataColumns;
    }

    public static class ImplicitColumnOptions {
        private Path rootDir;
        private int partitionCount = -1;
        private List<Path> files;
        protected boolean useLegacyWildcardExpansion = true;

        public void setSelectionRoot(Path rootPath) {
            this.rootDir = rootPath;
        }

        public void setPartitionDepth(int partitionDepth) {
            this.partitionCount = partitionDepth;
        }

        public void setFiles(List<Path> files) {
            this.files = files;
        }

        public void useLegacyWildcardExpansion(boolean flag) {
            this.useLegacyWildcardExpansion = flag;
        }
    }
}

