/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.physical.impl.scan.framework;

import com.typesafe.config.Config;
import org.apache.drill.common.exceptions.CustomErrorContext;
import org.apache.drill.exec.ops.OperatorContext;
import org.apache.drill.exec.physical.impl.scan.framework.ManagedScanFramework;
import org.apache.drill.exec.physical.impl.scan.framework.SchemaNegotiator;
import org.apache.drill.exec.physical.resultSet.ResultSetLoader;
import org.apache.drill.exec.record.metadata.TupleMetadata;
import org.apache.drill.exec.server.options.OptionSet;

public class SchemaNegotiatorImpl
implements SchemaNegotiator {
    protected final ManagedScanFramework framework;
    private NegotiatorListener listener;
    protected CustomErrorContext context;
    protected TupleMetadata providedSchema;
    protected TupleMetadata tableSchema;
    protected boolean isSchemaComplete;
    protected int batchSize = 65536;
    protected long limit = -1L;

    public SchemaNegotiatorImpl(ManagedScanFramework framework) {
        this.framework = framework;
        this.providedSchema = framework.outputSchema();
    }

    public void bind(NegotiatorListener listener) {
        this.listener = listener;
    }

    @Override
    public boolean isProjectionEmpty() {
        return this.framework.scanOrchestrator().isProjectNone();
    }

    @Override
    public boolean hasProvidedSchema() {
        return this.providedSchema != null && this.providedSchema.size() > 0;
    }

    @Override
    public TupleMetadata providedSchema() {
        return this.providedSchema;
    }

    @Override
    public OperatorContext context() {
        return this.framework.context();
    }

    @Override
    public Config drillConfig() {
        return this.context().getFragmentContext().getConfig();
    }

    @Override
    public OptionSet queryOptions() {
        return this.context().getFragmentContext().getOptions();
    }

    @Override
    public CustomErrorContext parentErrorContext() {
        return this.framework.errorContext();
    }

    public CustomErrorContext errorContext() {
        return this.context;
    }

    @Override
    public void setErrorContext(CustomErrorContext context) {
        this.context = context;
    }

    @Override
    public void tableSchema(TupleMetadata schema, boolean isComplete) {
        this.tableSchema = schema;
        this.isSchemaComplete = schema != null && isComplete;
    }

    public boolean isSchemaComplete() {
        return this.tableSchema != null && this.isSchemaComplete;
    }

    @Override
    public void batchSize(int maxRecordsPerBatch) {
        this.batchSize = maxRecordsPerBatch;
    }

    @Override
    public String userName() {
        return this.framework.builder.userName;
    }

    @Override
    public void limit(long limit) {
        this.limit = limit;
    }

    @Override
    public ResultSetLoader build() {
        return this.listener.build(this);
    }

    public static interface NegotiatorListener {
        public ResultSetLoader build(SchemaNegotiatorImpl var1);
    }
}

