/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.physical.impl.scan.framework;

import org.apache.drill.common.exceptions.UserException;
import org.apache.drill.exec.physical.impl.scan.RowBatchReader;
import org.apache.drill.exec.physical.impl.scan.framework.ManagedReader;
import org.apache.drill.exec.physical.impl.scan.framework.ManagedScanFramework;
import org.apache.drill.exec.physical.impl.scan.framework.SchemaNegotiator;
import org.apache.drill.exec.physical.impl.scan.framework.SchemaNegotiatorImpl;
import org.apache.drill.exec.physical.impl.scan.project.ReaderSchemaOrchestrator;
import org.apache.drill.exec.physical.resultSet.ResultSetLoader;
import org.apache.drill.exec.record.VectorContainer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ShimBatchReader
implements RowBatchReader,
SchemaNegotiatorImpl.NegotiatorListener {
    static final Logger logger = LoggerFactory.getLogger(ShimBatchReader.class);
    protected final ManagedScanFramework framework;
    protected final ManagedReader<? extends SchemaNegotiator> reader;
    protected final ReaderSchemaOrchestrator readerOrchestrator;
    protected SchemaNegotiatorImpl schemaNegotiator;
    protected ResultSetLoader tableLoader;
    private boolean eof;

    public ShimBatchReader(ManagedScanFramework manager, ManagedReader<? extends SchemaNegotiator> reader) {
        this.framework = manager;
        this.reader = reader;
        this.readerOrchestrator = manager.scanOrchestrator().startReader();
    }

    @Override
    public String name() {
        return this.reader.getClass().getSimpleName();
    }

    public ManagedReader<? extends SchemaNegotiator> reader() {
        return this.reader;
    }

    @Override
    public boolean open() {
        if (!this.framework.open(this)) {
            assert (this.tableLoader == null);
            if (this.tableLoader != null) {
                logger.warn("Reader " + this.reader.getClass().getSimpleName() + " returned false from open, but negotiated a schema.");
            }
            return false;
        }
        if (this.tableLoader == null) {
            throw UserException.internalError(null).addContext("Reader " + this.reader.getClass().getSimpleName() + " returned true from open, but did not call SchemaNegotiator.build().").build(logger);
        }
        return true;
    }

    @Override
    public boolean defineSchema() {
        if (this.schemaNegotiator.isSchemaComplete()) {
            this.readerOrchestrator.defineSchema();
            return true;
        }
        return false;
    }

    @Override
    public boolean next() {
        if (this.eof && !this.tableLoader.hasRows()) {
            return false;
        }
        if (this.tableLoader.atLimit()) {
            return false;
        }
        if (!this.readerOrchestrator.startBatch()) {
            this.eof = true;
            return false;
        }
        if (!this.eof) {
            this.eof = !this.reader.next();
        }
        this.eof = this.readerOrchestrator.endBatch(this.eof);
        return !this.eof || this.tableLoader.hasRows();
    }

    @Override
    public VectorContainer output() {
        if (this.framework.scanOrchestrator().hasSchema()) {
            return this.framework.scanOrchestrator().output();
        }
        return null;
    }

    @Override
    public void close() {
        RuntimeException ex = null;
        try {
            this.reader.close();
        }
        catch (RuntimeException e) {
            ex = e;
        }
        this.framework.scanOrchestrator().closeReader();
        if (ex != null) {
            throw ex;
        }
    }

    @Override
    public int schemaVersion() {
        return this.tableLoader.schemaVersion();
    }

    @Override
    public ResultSetLoader build(SchemaNegotiatorImpl schemaNegotiator) {
        this.schemaNegotiator = schemaNegotiator;
        this.readerOrchestrator.setBatchSize(schemaNegotiator.batchSize);
        this.tableLoader = this.readerOrchestrator.makeTableLoader(schemaNegotiator.errorContext(), schemaNegotiator.tableSchema, schemaNegotiator.limit);
        return this.tableLoader;
    }
}

