/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.physical.impl.scan.project;

import org.apache.drill.exec.physical.impl.scan.project.ColumnProjection;
import org.apache.drill.exec.physical.resultSet.project.RequestedColumn;
import org.apache.drill.exec.record.metadata.ColumnMetadata;

public abstract class AbstractUnresolvedColumn
implements ColumnProjection {
    protected final RequestedColumn inCol;

    public AbstractUnresolvedColumn(RequestedColumn inCol) {
        this.inCol = inCol;
    }

    @Override
    public String name() {
        return this.inCol.name();
    }

    public RequestedColumn element() {
        return this.inCol;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append("[").append(this.getClass().getSimpleName()).append(" type=").append(this.getClass().getSimpleName());
        if (this.inCol != null) {
            buf.append(", incol=").append(this.inCol.toString());
        }
        return buf.append("]").toString();
    }

    public static class UnresolvedWildcardColumn
    extends AbstractUnresolvedColumn {
        public UnresolvedWildcardColumn(RequestedColumn inCol) {
            super(inCol);
        }
    }

    public static class UnresolvedColumn
    extends AbstractUnresolvedColumn {
        private final ColumnMetadata colDefn;

        public UnresolvedColumn(RequestedColumn inCol) {
            this(inCol, null);
        }

        public UnresolvedColumn(RequestedColumn inCol, ColumnMetadata colDefn) {
            super(inCol);
            this.colDefn = colDefn;
        }

        public ColumnMetadata metadata() {
            return this.colDefn;
        }

        @Override
        public String name() {
            return this.colDefn == null ? super.name() : this.colDefn.name();
        }
    }
}

