/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.physical.impl.scan.project;

import java.util.List;
import org.apache.drill.exec.physical.impl.scan.project.StaticColumnLoader;
import org.apache.drill.exec.physical.resultSet.ResultVectorCache;
import org.apache.drill.exec.physical.resultSet.RowSetLoader;
import org.apache.drill.exec.record.MaterializedField;
import org.apache.drill.exec.record.VectorContainer;
import org.apache.drill.exec.vector.accessor.TupleWriter;

public class ConstantColumnLoader
extends StaticColumnLoader {
    private final String[] values;
    private final List<? extends ConstantColumnSpec> constantCols;

    public ConstantColumnLoader(ResultVectorCache vectorCache, List<? extends ConstantColumnSpec> defns) {
        super(vectorCache);
        this.constantCols = defns;
        RowSetLoader schema = this.loader.writer();
        this.values = new String[defns.size()];
        for (int i = 0; i < defns.size(); ++i) {
            ConstantColumnSpec defn = defns.get(i);
            this.values[i] = defn.value();
            schema.addColumn(defn.schema());
        }
    }

    @Override
    public VectorContainer load(int rowCount) {
        this.loader.startBatch();
        RowSetLoader writer = this.loader.writer();
        for (int i = 0; i < rowCount; ++i) {
            writer.start();
            this.loadRow(writer);
            writer.save();
        }
        return this.loader.harvest();
    }

    private void loadRow(TupleWriter writer) {
        for (int i = 0; i < this.values.length; ++i) {
            if (this.values[i] == null) {
                writer.scalar(i).setNull();
                continue;
            }
            writer.scalar(i).setString(this.values[i]);
        }
    }

    public List<? extends ConstantColumnSpec> columns() {
        return this.constantCols;
    }

    public static interface ConstantColumnSpec {
        public String name();

        public MaterializedField schema();

        public String value();
    }
}

