/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.physical.impl.scan.project;

import java.util.List;
import org.apache.drill.common.exceptions.UserException;
import org.apache.drill.common.types.TypeProtos;
import org.apache.drill.exec.physical.impl.scan.project.AbstractUnresolvedColumn;
import org.apache.drill.exec.physical.impl.scan.project.ColumnProjection;
import org.apache.drill.exec.physical.impl.scan.project.ReaderLevelProjection;
import org.apache.drill.exec.physical.impl.scan.project.ResolvedColumn;
import org.apache.drill.exec.physical.impl.scan.project.ResolvedDictColumn;
import org.apache.drill.exec.physical.impl.scan.project.ResolvedMapColumn;
import org.apache.drill.exec.physical.impl.scan.project.ResolvedTableColumn;
import org.apache.drill.exec.physical.impl.scan.project.ResolvedTuple;
import org.apache.drill.exec.physical.impl.scan.project.ScanLevelProjection;
import org.apache.drill.exec.physical.resultSet.project.RequestedColumn;
import org.apache.drill.exec.physical.resultSet.project.RequestedTuple;
import org.apache.drill.exec.record.MaterializedField;
import org.apache.drill.exec.record.metadata.ColumnMetadata;
import org.apache.drill.exec.record.metadata.MetadataUtils;
import org.apache.drill.exec.record.metadata.PrimitiveColumnMetadata;
import org.apache.drill.exec.record.metadata.TupleMetadata;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExplicitSchemaProjection
extends ReaderLevelProjection {
    private static final Logger logger = LoggerFactory.getLogger(ExplicitSchemaProjection.class);
    private final ScanLevelProjection scanProj;

    public ExplicitSchemaProjection(ScanLevelProjection scanProj, TupleMetadata readerSchema, ResolvedTuple rootTuple, List<ReaderLevelProjection.ReaderProjectionResolver> resolvers) {
        super(resolvers);
        this.scanProj = scanProj;
        this.resolveRootTuple(rootTuple, readerSchema);
    }

    private void resolveRootTuple(ResolvedTuple rootTuple, TupleMetadata readerSchema) {
        for (ColumnProjection col : this.scanProj.columns()) {
            if (col instanceof AbstractUnresolvedColumn.UnresolvedColumn) {
                this.resolveColumn(rootTuple, ((AbstractUnresolvedColumn.UnresolvedColumn)col).element(), readerSchema);
                continue;
            }
            this.resolveSpecial(rootTuple, col, readerSchema);
        }
    }

    private void resolveColumn(ResolvedTuple outputTuple, RequestedColumn inputCol, TupleMetadata readerSchema) {
        int tableColIndex = readerSchema.index(inputCol.name());
        if (tableColIndex == -1) {
            this.resolveNullColumn(outputTuple, inputCol);
        } else {
            this.resolveTableColumn(outputTuple, inputCol, readerSchema.metadata(tableColIndex), tableColIndex);
        }
    }

    private void resolveDictValueColumn(ResolvedTuple outputTuple, RequestedColumn inputCol, TupleMetadata readerSchema) {
        int tableColIndex = readerSchema.index("value");
        if (tableColIndex == -1) {
            this.resolveNullColumn(outputTuple, inputCol);
        } else {
            this.resolveTableColumn(outputTuple, inputCol, readerSchema.metadata(tableColIndex), tableColIndex);
        }
    }

    private void resolveTableColumn(ResolvedTuple outputTuple, RequestedColumn requestedCol, ColumnMetadata column, int sourceIndex) {
        if (requestedCol.isTuple()) {
            if (column.isDict()) {
                this.resolveDict(outputTuple, requestedCol, column, sourceIndex);
            } else {
                this.resolveMap(outputTuple, requestedCol, column, sourceIndex);
            }
        } else if (requestedCol.isArray()) {
            this.resolveArray(outputTuple, requestedCol, column, sourceIndex);
        } else {
            this.projectTableColumn(outputTuple, requestedCol, column, sourceIndex);
        }
    }

    private void resolveMap(ResolvedTuple outputTuple, RequestedColumn requestedCol, ColumnMetadata column, int sourceIndex) {
        if (!column.isMap()) {
            if (column.isScalar() && ((PrimitiveColumnMetadata)column).isSchemaForUnknown()) {
                column = MetadataUtils.newMap(column.name());
            } else {
                throw UserException.validationError().message("Project list implies a map column, but actual column is not a map", new Object[0]).addContext("Projected column:", requestedCol.fullName()).addContext("Table column:", column.name()).addContext("Type:", column.type().name()).addContext(this.scanProj.context()).build(logger);
            }
        }
        ResolvedMapColumn mapCol = new ResolvedMapColumn(outputTuple, column.schema(), sourceIndex);
        this.resolveTuple(mapCol.members(), requestedCol.tuple(), column.tupleSchema());
        if (mapCol.members().isSimpleProjection()) {
            outputTuple.removeChild(mapCol.members());
            this.projectTableColumn(outputTuple, requestedCol, column, sourceIndex);
        } else {
            outputTuple.add(mapCol);
        }
    }

    private void resolveDict(ResolvedTuple outputTuple, RequestedColumn requestedCol, ColumnMetadata column, int sourceIndex) {
        if (!column.isDict()) {
            if (column.isScalar() && ((PrimitiveColumnMetadata)column).isSchemaForUnknown()) {
                column = MetadataUtils.newDict(column.name());
            } else {
                throw UserException.validationError().message("Project list implies a dict column, but actual column is not a dict", new Object[0]).addContext("Projected column:", requestedCol.fullName()).addContext("Table column:", column.name()).addContext("Type:", column.type().name()).addContext(this.scanProj.context()).build(logger);
            }
        }
        ResolvedDictColumn dictColumn = new ResolvedDictColumn(outputTuple, column.schema(), sourceIndex);
        this.resolveDictTuple(dictColumn.members(), requestedCol.tuple(), column.tupleSchema());
        if (dictColumn.members().isSimpleProjection()) {
            outputTuple.removeChild(dictColumn.members());
            this.projectTableColumn(outputTuple, requestedCol, column, sourceIndex);
        } else {
            outputTuple.add(dictColumn);
        }
    }

    private void resolveTuple(ResolvedTuple mapTuple, RequestedTuple requestedTuple, TupleMetadata mapSchema) {
        for (RequestedColumn col : requestedTuple.projections()) {
            this.resolveColumn(mapTuple, col, mapSchema);
        }
    }

    private void resolveDictTuple(ResolvedTuple mapTuple, RequestedTuple requestedTuple, TupleMetadata mapSchema) {
        for (RequestedColumn col : requestedTuple.projections()) {
            this.resolveDictValueColumn(mapTuple, col, mapSchema);
        }
    }

    private void resolveArray(ResolvedTuple outputTuple, RequestedColumn requestedCol, ColumnMetadata column, int sourceIndex) {
        if (column.type() != TypeProtos.MinorType.LIST && !column.isArray()) {
            throw UserException.validationError().message("Project list implies an array, but actual column is not an array", new Object[0]).addContext("Projected column:", requestedCol.fullName()).addContext("Table column:", column.name()).addContext("Type:", column.type().name()).addContext("Actual cardinality:", column.mode().name()).addContext(this.scanProj.context()).build(logger);
        }
        this.projectTableColumn(outputTuple, requestedCol, column, sourceIndex);
    }

    private void projectTableColumn(ResolvedTuple outputTuple, RequestedColumn requestedCol, ColumnMetadata column, int sourceIndex) {
        outputTuple.add(new ResolvedTableColumn(requestedCol.name(), MaterializedField.create(requestedCol.name(), column.majorType()), outputTuple, sourceIndex));
    }

    private void resolveNullColumn(ResolvedTuple outputTuple, RequestedColumn requestedCol) {
        ResolvedColumn nullCol = requestedCol.isTuple() ? this.resolveMapMembers(outputTuple, requestedCol) : outputTuple.nullBuilder.add(requestedCol.name());
        outputTuple.add(nullCol);
    }

    private ResolvedColumn resolveMapMembers(ResolvedTuple outputTuple, RequestedColumn col) {
        ResolvedMapColumn mapCol = new ResolvedMapColumn(outputTuple, col.name());
        ResolvedTuple members = mapCol.members();
        for (RequestedColumn child : col.tuple().projections()) {
            if (child.isTuple()) {
                members.add(this.resolveMapMembers(members, child));
                continue;
            }
            members.add(members.nullBuilder.add(child.name()));
        }
        return mapCol;
    }
}

