/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.physical.impl.scan.project;

import java.util.ArrayList;
import java.util.List;
import org.apache.drill.common.types.TypeProtos;
import org.apache.drill.exec.physical.impl.scan.project.NullColumnLoader;
import org.apache.drill.exec.physical.impl.scan.project.ResolvedNullColumn;
import org.apache.drill.exec.physical.impl.scan.project.VectorSource;
import org.apache.drill.exec.physical.resultSet.ResultVectorCache;
import org.apache.drill.exec.record.VectorContainer;
import org.apache.drill.exec.record.metadata.ColumnMetadata;
import org.apache.drill.exec.record.metadata.TupleMetadata;
import org.apache.drill.exec.vector.ValueVector;
import org.apache.drill.shaded.guava.com.google.common.annotations.VisibleForTesting;

public class NullColumnBuilder
implements VectorSource {
    protected final List<NullColumnLoader.NullColumnSpec> nullCols = new ArrayList<NullColumnLoader.NullColumnSpec>();
    private NullColumnLoader nullColumnLoader;
    private VectorContainer outputContainer;
    protected TupleMetadata outputSchema;
    private final TypeProtos.MajorType nullType;
    private final boolean allowRequiredNullColumns;

    public NullColumnBuilder(NullBuilderBuilder builder) {
        this.nullType = builder.nullType;
        this.allowRequiredNullColumns = builder.allowRequiredNullColumns;
        this.outputSchema = builder.outputSchema;
    }

    public NullColumnBuilder newChild(String mapName) {
        ColumnMetadata colSchema;
        NullBuilderBuilder builder = new NullBuilderBuilder().setNullType(this.nullType).allowRequiredNullColumns(this.allowRequiredNullColumns);
        if (this.outputSchema != null && (colSchema = this.outputSchema.metadata(mapName)) != null) {
            builder.setOutputSchema(colSchema.tupleSchema());
        }
        return builder.build();
    }

    public ResolvedNullColumn add(String name) {
        return this.add(name, null);
    }

    public ResolvedNullColumn add(ColumnMetadata colDefn) {
        ResolvedNullColumn col = new ResolvedNullColumn(colDefn, this, this.nullCols.size());
        this.nullCols.add(col);
        return col;
    }

    public ResolvedNullColumn add(String name, TypeProtos.MajorType type) {
        ColumnMetadata outputCol;
        ResolvedNullColumn col = null;
        if (this.outputSchema != null && (outputCol = this.outputSchema.metadata(name)) != null) {
            if (type == null) {
                col = new ResolvedNullColumn(outputCol, this, this.nullCols.size());
            } else if (type.getMinorType() == outputCol.type()) {
                col = type.getMode() != outputCol.mode() ? new ResolvedNullColumn(name, type, outputCol.defaultValue(), this, this.nullCols.size()) : new ResolvedNullColumn(outputCol, this, this.nullCols.size());
            }
        }
        if (col == null) {
            col = new ResolvedNullColumn(name, type, null, this, this.nullCols.size());
        }
        this.nullCols.add(col);
        return col;
    }

    public void build(ResultVectorCache vectorCache) {
        this.close();
        if (this.hasColumns()) {
            this.nullColumnLoader = new NullColumnLoader(vectorCache, this.nullCols, this.nullType, this.allowRequiredNullColumns);
            this.outputContainer = this.nullColumnLoader.output();
        }
    }

    public boolean hasColumns() {
        return this.nullCols != null && !this.nullCols.isEmpty();
    }

    public void load(int rowCount) {
        if (this.nullColumnLoader != null) {
            VectorContainer output = this.nullColumnLoader.load(rowCount);
            assert (output == this.outputContainer);
        }
    }

    @Override
    public ValueVector vector(int index) {
        return this.outputContainer.getValueVector(index).getValueVector();
    }

    @VisibleForTesting
    public VectorContainer output() {
        return this.outputContainer;
    }

    public void close() {
        if (this.nullColumnLoader != null) {
            this.nullColumnLoader.close();
            this.nullColumnLoader = null;
        }
        if (this.outputContainer != null) {
            this.outputContainer.clear();
            this.outputContainer = null;
        }
    }

    public static class NullBuilderBuilder {
        protected TypeProtos.MajorType nullType;
        protected boolean allowRequiredNullColumns;
        protected TupleMetadata outputSchema;

        public NullBuilderBuilder setNullType(TypeProtos.MajorType nullType) {
            this.nullType = nullType;
            return this;
        }

        public NullBuilderBuilder allowRequiredNullColumns(boolean flag) {
            this.allowRequiredNullColumns = flag;
            return this;
        }

        public NullBuilderBuilder setOutputSchema(TupleMetadata outputSchema) {
            this.outputSchema = outputSchema;
            return this;
        }

        public NullColumnBuilder build() {
            return new NullColumnBuilder(this);
        }
    }
}

