/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.physical.impl.scan.project;

import java.util.List;
import org.apache.drill.common.types.TypeProtos;
import org.apache.drill.exec.physical.impl.scan.project.StaticColumnLoader;
import org.apache.drill.exec.physical.resultSet.ResultVectorCache;
import org.apache.drill.exec.physical.resultSet.RowSetLoader;
import org.apache.drill.exec.record.VectorContainer;
import org.apache.drill.exec.record.metadata.ColumnMetadata;
import org.apache.drill.exec.record.metadata.MetadataUtils;

public class NullColumnLoader
extends StaticColumnLoader {
    public static final TypeProtos.MajorType DEFAULT_NULL_TYPE = TypeProtos.MajorType.newBuilder().setMinorType(TypeProtos.MinorType.INT).setMode(TypeProtos.DataMode.OPTIONAL).build();
    private final TypeProtos.MajorType nullType;
    private final boolean allowRequired;

    public NullColumnLoader(ResultVectorCache vectorCache, List<? extends NullColumnSpec> defns, TypeProtos.MajorType nullType, boolean allowRequired) {
        super(vectorCache);
        this.allowRequired = allowRequired || nullType != null && nullType.getMode() == TypeProtos.DataMode.REQUIRED;
        this.nullType = nullType == null ? DEFAULT_NULL_TYPE : nullType;
        RowSetLoader schema = this.loader.writer();
        for (int i = 0; i < defns.size(); ++i) {
            NullColumnSpec defn = defns.get(i);
            ColumnMetadata colSchema = this.selectType(defn);
            if (defn.metadata() != null) {
                colSchema.setProperties(defn.metadata().properties());
            } else if (defn.defaultValue() != null) {
                colSchema.setDefaultValue(defn.defaultValue());
            }
            schema.addColumn(colSchema);
        }
    }

    private ColumnMetadata selectType(NullColumnSpec defn) {
        TypeProtos.MajorType type = this.vectorCache.getType(defn.name());
        if (type == null) {
            type = defn.type();
        }
        if (type != null && !this.allowRequired && type.getMode() == TypeProtos.DataMode.REQUIRED && defn.defaultValue() == null) {
            type = TypeProtos.MajorType.newBuilder().setMinorType(type.getMinorType()).setMode(TypeProtos.DataMode.OPTIONAL).build();
        }
        if (type == null) {
            type = this.nullType;
        }
        if (type.getMinorType() == TypeProtos.MinorType.NULL) {
            type = this.nullType;
        }
        defn.setType(type);
        return MetadataUtils.newScalar(defn.name(), type);
    }

    public VectorContainer output() {
        return this.loader.outputContainer();
    }

    @Override
    public VectorContainer load(int rowCount) {
        this.loader.startBatch();
        this.loader.skipRows(rowCount);
        return this.loader.harvest();
    }

    public static interface NullColumnSpec {
        public String name();

        public TypeProtos.MajorType type();

        public void setType(TypeProtos.MajorType var1);

        public String defaultValue();

        public ColumnMetadata metadata();
    }
}

