/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.physical.impl.scan.project;

import java.util.ArrayList;
import java.util.List;
import org.apache.drill.exec.physical.impl.scan.project.ColumnProjection;
import org.apache.drill.exec.physical.impl.scan.project.ResolvedTuple;
import org.apache.drill.exec.record.metadata.TupleMetadata;

public class ReaderLevelProjection {
    protected final List<ReaderProjectionResolver> resolvers;

    protected ReaderLevelProjection(List<ReaderProjectionResolver> resolvers) {
        this.resolvers = resolvers == null ? new ArrayList() : resolvers;
        for (ReaderProjectionResolver resolver : resolvers) {
            resolver.startResolution();
        }
    }

    protected void resolveSpecial(ResolvedTuple rootOutputTuple, ColumnProjection col, TupleMetadata tableSchema) {
        for (ReaderProjectionResolver resolver : this.resolvers) {
            if (!resolver.resolveColumn(col, rootOutputTuple, tableSchema)) continue;
            return;
        }
        throw new IllegalStateException(String.format("No resolver for column `%s` of type %s", col.name(), col.getClass().getSimpleName()));
    }

    public static interface ReaderProjectionResolver {
        public void startResolution();

        public boolean resolveColumn(ColumnProjection var1, ResolvedTuple var2, TupleMetadata var3);
    }
}

