/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.physical.impl.scan.project;

import org.apache.drill.common.types.TypeProtos;
import org.apache.drill.exec.physical.impl.scan.project.NullColumnLoader;
import org.apache.drill.exec.physical.impl.scan.project.ResolvedColumn;
import org.apache.drill.exec.physical.impl.scan.project.VectorSource;
import org.apache.drill.exec.record.MaterializedField;
import org.apache.drill.exec.record.metadata.ColumnMetadata;

public class ResolvedNullColumn
extends ResolvedColumn
implements NullColumnLoader.NullColumnSpec {
    private final String name;
    private TypeProtos.MajorType type;
    private String defaultValue;

    public ResolvedNullColumn(String name, TypeProtos.MajorType type, String defaultValue, VectorSource source, int sourceIndex) {
        super(source, sourceIndex);
        this.name = name;
        this.type = type;
        this.defaultValue = defaultValue;
    }

    public ResolvedNullColumn(ColumnMetadata colDefn, VectorSource source, int sourceIndex) {
        super(colDefn, source, sourceIndex);
        this.name = colDefn.name();
        this.type = colDefn.majorType();
        this.defaultValue = colDefn.defaultValue();
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public TypeProtos.MajorType type() {
        return this.type;
    }

    @Override
    public void setType(TypeProtos.MajorType type) {
        if (this.type != null && type.getMinorType() != this.type.getMinorType()) {
            this.defaultValue = null;
        }
        this.type = type;
    }

    @Override
    public MaterializedField schema() {
        return MaterializedField.create(this.name, this.type);
    }

    @Override
    public String defaultValue() {
        return this.defaultValue;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append("[").append(this.getClass().getSimpleName()).append(" name=").append(this.name()).append("]");
        return buf.toString();
    }
}

