/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.physical.impl.scan.project;

import org.apache.drill.exec.physical.impl.scan.project.ResolvedColumn;
import org.apache.drill.exec.physical.impl.scan.project.VectorSource;
import org.apache.drill.exec.record.MaterializedField;
import org.apache.drill.exec.record.metadata.ColumnMetadata;

public class ResolvedTableColumn
extends ResolvedColumn {
    private final String projectedName;
    private final MaterializedField schema;

    public ResolvedTableColumn(String projectedName, MaterializedField schema, VectorSource source, int sourceIndex) {
        super(source, sourceIndex);
        this.projectedName = projectedName;
        this.schema = schema;
    }

    public ResolvedTableColumn(ColumnMetadata outputCol, VectorSource source, int sourceIndex) {
        super(outputCol, source, sourceIndex);
        this.projectedName = outputCol.name();
        this.schema = outputCol.schema();
    }

    @Override
    public String name() {
        return this.projectedName;
    }

    @Override
    public MaterializedField schema() {
        return this.schema;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append("[").append(this.getClass().getSimpleName()).append(" name=").append(this.name()).append("]");
        return buf.toString();
    }
}

