/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.physical.impl.scan.project;

import java.util.ArrayList;
import java.util.List;
import org.apache.drill.common.exceptions.CustomErrorContext;
import org.apache.drill.common.expression.SchemaPath;
import org.apache.drill.exec.physical.impl.scan.project.AbstractUnresolvedColumn;
import org.apache.drill.exec.physical.impl.scan.project.ColumnProjection;
import org.apache.drill.exec.physical.resultSet.impl.ProjectionFilter;
import org.apache.drill.exec.physical.resultSet.project.ImpliedTupleRequest;
import org.apache.drill.exec.physical.resultSet.project.Projections;
import org.apache.drill.exec.physical.resultSet.project.RequestedColumn;
import org.apache.drill.exec.physical.resultSet.project.RequestedTuple;
import org.apache.drill.exec.record.metadata.ColumnMetadata;
import org.apache.drill.exec.record.metadata.TupleMetadata;
import org.apache.drill.shaded.guava.com.google.common.annotations.VisibleForTesting;

public class ScanLevelProjection {
    protected final CustomErrorContext errorContext;
    protected final List<SchemaPath> projectionList;
    protected final TupleMetadata readerSchema;
    protected List<ScanProjectionParser> parsers;
    protected boolean includesWildcard;
    protected boolean sawWildcard;
    protected List<ColumnProjection> outputCols = new ArrayList<ColumnProjection>();
    protected RequestedTuple outputProjection;
    protected ProjectionFilter readerProjection;
    protected ScanProjectionType projectionType;

    private ScanLevelProjection(Builder builder) {
        this.projectionList = builder.projectionList();
        this.parsers = builder.parsers;
        this.readerSchema = builder.providedSchema();
        this.errorContext = builder.errorContext;
        this.doParse();
    }

    public static Builder builder() {
        return new Builder();
    }

    @VisibleForTesting
    public static ScanLevelProjection build(List<SchemaPath> projectionList, List<ScanProjectionParser> parsers) {
        return new Builder().projection(projectionList).parsers(parsers).build();
    }

    @VisibleForTesting
    public static ScanLevelProjection build(List<SchemaPath> projectionList, List<ScanProjectionParser> parsers, TupleMetadata outputSchema) {
        return new Builder().projection(projectionList).parsers(parsers).providedSchema(outputSchema).build();
    }

    private void doParse() {
        this.outputProjection = Projections.parse(this.projectionList);
        switch (this.outputProjection.type()) {
            case ALL: {
                this.includesWildcard = true;
                this.projectionType = ScanProjectionType.WILDCARD;
                break;
            }
            case NONE: {
                this.projectionType = ScanProjectionType.EMPTY;
                break;
            }
            default: {
                this.projectionType = ScanProjectionType.EXPLICIT;
            }
        }
        for (ScanProjectionParser parser : this.parsers) {
            parser.bind(this);
        }
        for (RequestedColumn inCol : this.outputProjection.projections()) {
            if (inCol.isWildcard()) {
                this.mapWildcard(inCol);
                continue;
            }
            this.mapColumn(inCol);
        }
        this.verify();
        for (ScanProjectionParser parser : this.parsers) {
            parser.build();
        }
        this.buildReaderProjection();
    }

    private void buildReaderProjection() {
        RequestedTuple rootProjection;
        if (this.projectionType == ScanProjectionType.EMPTY) {
            rootProjection = ImpliedTupleRequest.NO_MEMBERS;
        } else if (this.projectionType != ScanProjectionType.EXPLICIT) {
            rootProjection = ImpliedTupleRequest.ALL_MEMBERS;
        } else {
            ArrayList<RequestedColumn> outputProj = new ArrayList<RequestedColumn>();
            for (ColumnProjection col : this.outputCols) {
                if (!(col instanceof AbstractUnresolvedColumn)) continue;
                outputProj.add(((AbstractUnresolvedColumn)col).element());
            }
            rootProjection = Projections.build(outputProj);
        }
        this.readerProjection = ProjectionFilter.providedSchemaFilter(rootProjection, this.readerSchema, this.errorContext);
    }

    private void mapWildcard(RequestedColumn inCol) {
        assert (this.includesWildcard);
        if (this.sawWildcard) {
            throw new IllegalArgumentException("Duplicate * entry in project list");
        }
        assert (this.projectionType == ScanProjectionType.WILDCARD);
        boolean expanded = this.expandOutputSchema();
        int wildcardPosn = this.outputCols.size();
        for (ScanProjectionParser parser : this.parsers) {
            if (!parser.parse(inCol)) continue;
            wildcardPosn = -1;
        }
        this.sawWildcard = true;
        if (expanded) {
            this.projectionType = this.readerSchema.booleanProperty("drill.strict") ? ScanProjectionType.STRICT_SCHEMA_WILDCARD : ScanProjectionType.SCHEMA_WILDCARD;
        } else if (wildcardPosn != -1) {
            this.outputCols.add(wildcardPosn, new AbstractUnresolvedColumn.UnresolvedWildcardColumn(inCol));
        }
    }

    private boolean expandOutputSchema() {
        if (this.readerSchema == null) {
            return false;
        }
        for (int i = 0; i < this.readerSchema.size(); ++i) {
            ColumnMetadata col = this.readerSchema.metadata(i);
            if (col.booleanProperty("drill.special")) continue;
            this.outputCols.add(new AbstractUnresolvedColumn.UnresolvedColumn(null, col));
        }
        return true;
    }

    private void mapColumn(RequestedColumn inCol) {
        for (ScanProjectionParser parser : this.parsers) {
            if (!parser.parse(inCol)) continue;
            return;
        }
        if (this.includesWildcard) {
            return;
        }
        this.addTableColumn(inCol);
    }

    private void addTableColumn(RequestedColumn inCol) {
        ColumnMetadata outputCol = null;
        if (this.readerSchema != null) {
            outputCol = this.readerSchema.metadata(inCol.name());
        }
        this.addTableColumn(new AbstractUnresolvedColumn.UnresolvedColumn(inCol, outputCol));
    }

    public void addTableColumn(ColumnProjection outCol) {
        this.outputCols.add(outCol);
    }

    public void addMetadataColumn(ColumnProjection outCol) {
        this.outputCols.add(outCol);
    }

    private void verify() {
        for (ScanProjectionParser parser : this.parsers) {
            parser.validate();
        }
        for (ColumnProjection outCol : this.outputCols) {
            for (ScanProjectionParser parser : this.parsers) {
                parser.validateColumn(outCol);
            }
        }
    }

    public CustomErrorContext context() {
        return this.errorContext;
    }

    public List<SchemaPath> requestedCols() {
        return this.projectionList;
    }

    public List<ColumnProjection> columns() {
        return this.outputCols;
    }

    public ScanProjectionType projectionType() {
        return this.projectionType;
    }

    public boolean projectAll() {
        return this.projectionType.isWildcard();
    }

    public boolean isEmptyProjection() {
        return this.projectionType == ScanProjectionType.EMPTY;
    }

    public RequestedTuple rootProjection() {
        return this.outputProjection;
    }

    public ProjectionFilter readerProjection() {
        return this.readerProjection;
    }

    public boolean hasReaderSchema() {
        return this.readerSchema != null;
    }

    public TupleMetadata readerSchema() {
        return this.readerSchema;
    }

    public String toString() {
        return "[" + this.getClass().getSimpleName() + " projection=" + this.outputCols.toString() + "]";
    }

    public static class Builder {
        private List<SchemaPath> projectionList;
        private final List<ScanProjectionParser> parsers = new ArrayList<ScanProjectionParser>();
        private TupleMetadata providedSchema;
        protected CustomErrorContext errorContext;

        public Builder projection(List<SchemaPath> projectionList) {
            this.projectionList = projectionList;
            return this;
        }

        public Builder parsers(List<ScanProjectionParser> parsers) {
            this.parsers.addAll(parsers);
            return this;
        }

        public Builder providedSchema(TupleMetadata providedSchema) {
            this.providedSchema = providedSchema;
            return this;
        }

        public Builder errorContext(CustomErrorContext context) {
            this.errorContext = context;
            return this;
        }

        public ScanLevelProjection build() {
            return new ScanLevelProjection(this);
        }

        public TupleMetadata providedSchema() {
            return this.providedSchema == null || this.providedSchema.size() == 0 ? null : this.providedSchema;
        }

        public List<SchemaPath> projectionList() {
            if (this.projectionList == null) {
                this.projectionList = new ArrayList<SchemaPath>();
                this.projectionList.add(SchemaPath.STAR_COLUMN);
            }
            return this.projectionList;
        }
    }

    public static enum ScanProjectionType {
        EMPTY,
        WILDCARD,
        EXPLICIT,
        SCHEMA_WILDCARD,
        STRICT_SCHEMA_WILDCARD;


        public boolean isWildcard() {
            return this == WILDCARD || this == SCHEMA_WILDCARD || this == STRICT_SCHEMA_WILDCARD;
        }
    }

    public static interface ScanProjectionParser {
        public void bind(ScanLevelProjection var1);

        public boolean parse(RequestedColumn var1);

        public void validate();

        public void validateColumn(ColumnProjection var1);

        public void build();
    }
}

