/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.physical.impl.scan.project;

import java.util.ArrayList;
import java.util.List;
import org.apache.drill.common.exceptions.CustomErrorContext;
import org.apache.drill.common.expression.SchemaPath;
import org.apache.drill.common.types.TypeProtos;
import org.apache.drill.exec.memory.BufferAllocator;
import org.apache.drill.exec.ops.FragmentContext;
import org.apache.drill.exec.physical.base.PhysicalOperator;
import org.apache.drill.exec.physical.impl.protocol.OperatorRecordBatch;
import org.apache.drill.exec.physical.impl.scan.ScanOperatorEvents;
import org.apache.drill.exec.physical.impl.scan.ScanOperatorExec;
import org.apache.drill.exec.physical.impl.scan.project.MetadataManager;
import org.apache.drill.exec.physical.impl.scan.project.NoOpMetadataManager;
import org.apache.drill.exec.physical.impl.scan.project.ReaderLevelProjection;
import org.apache.drill.exec.physical.impl.scan.project.ReaderSchemaOrchestrator;
import org.apache.drill.exec.physical.impl.scan.project.ScanLevelProjection;
import org.apache.drill.exec.physical.impl.scan.project.SchemaSmoother;
import org.apache.drill.exec.physical.resultSet.impl.ResultVectorCacheImpl;
import org.apache.drill.exec.record.VectorContainer;
import org.apache.drill.exec.record.metadata.TupleMetadata;
import org.apache.drill.exec.vector.ValueVector;
import org.apache.drill.shaded.guava.com.google.common.annotations.VisibleForTesting;

public class ScanSchemaOrchestrator {
    public static final int MIN_BATCH_BYTE_SIZE = 262144;
    public static final int MAX_BATCH_BYTE_SIZE = Integer.MAX_VALUE;
    public static final int DEFAULT_BATCH_ROW_COUNT = 4096;
    public static final int DEFAULT_BATCH_BYTE_COUNT = ValueVector.MAX_BUFFER_SIZE;
    public static final int MAX_BATCH_ROW_COUNT = 65536;
    protected final BufferAllocator allocator;
    protected final ScanSchemaOptions options;
    public final MetadataManager metadataManager;
    protected final ResultVectorCacheImpl vectorCache;
    protected final ScanLevelProjection scanProj;
    private ReaderSchemaOrchestrator currentReader;
    protected final SchemaSmoother schemaSmoother;
    protected int batchCount;
    protected long rowCount;
    protected VectorContainer outputContainer;

    public ScanSchemaOrchestrator(BufferAllocator allocator, ScanOrchestratorBuilder builder) {
        this.allocator = allocator;
        this.options = new ScanSchemaOptions(builder);
        this.vectorCache = new ResultVectorCacheImpl(allocator, this.options.useSchemaSmoothing);
        this.metadataManager = builder.metadataManager == null ? new NoOpMetadataManager() : builder.metadataManager;
        this.metadataManager.bind(this.vectorCache);
        ScanLevelProjection.ScanProjectionParser parser = this.metadataManager.projectionParser();
        if (parser != null) {
            this.options.parsers.add(parser);
        }
        this.scanProj = ScanLevelProjection.builder().projection(this.options.projection).parsers(this.options.parsers).providedSchema(this.options.providedSchema()).errorContext(builder.errorContext()).build();
        this.schemaSmoother = this.scanProj.projectAll() && this.options.useSchemaSmoothing ? new SchemaSmoother(this.scanProj, this.options.schemaResolvers) : null;
        this.outputContainer = new VectorContainer(allocator);
    }

    public ReaderSchemaOrchestrator startReader() {
        this.closeReader();
        this.currentReader = new ReaderSchemaOrchestrator(this, this.options.limit - this.rowCount);
        return this.currentReader;
    }

    public boolean isProjectNone() {
        return this.scanProj.isEmptyProjection();
    }

    public boolean hasSchema() {
        return this.currentReader != null && this.currentReader.hasSchema();
    }

    public TupleMetadata providedSchema() {
        return this.options.providedSchema();
    }

    public VectorContainer output() {
        return this.outputContainer;
    }

    public void tallyBatch(int rowCount) {
        ++this.batchCount;
        this.rowCount += (long)rowCount;
    }

    public boolean atLimit() {
        return this.batchCount > 0 && this.rowCount >= this.options.limit;
    }

    public void closeReader() {
        if (this.currentReader != null) {
            this.currentReader.close();
            this.currentReader = null;
        }
    }

    public void close() {
        this.closeReader();
        if (this.outputContainer != null) {
            this.outputContainer.clear();
            this.outputContainer = null;
        }
        this.vectorCache.close();
        this.metadataManager.close();
    }

    public static class ScanSchemaOptions {
        public final TypeProtos.MajorType nullType;
        public final int scanBatchRecordLimit;
        public final int scanBatchByteLimit;
        public final List<ScanLevelProjection.ScanProjectionParser> parsers;
        public final List<ReaderLevelProjection.ReaderProjectionResolver> schemaResolvers;
        public final List<SchemaPath> projection;
        public final boolean useSchemaSmoothing;
        public final boolean allowRequiredNullColumns;
        public final TupleMetadata providedSchema;
        public final long limit;
        public final CustomErrorContext context;

        protected ScanSchemaOptions(ScanOrchestratorBuilder builder) {
            this.nullType = builder.nullType;
            this.scanBatchRecordLimit = builder.scanBatchRecordLimit;
            this.scanBatchByteLimit = builder.scanBatchByteLimit;
            this.parsers = builder.parsers;
            this.schemaResolvers = builder.schemaResolvers;
            this.projection = builder.projection;
            this.useSchemaSmoothing = builder.useSchemaSmoothing;
            this.context = builder.errorContext;
            this.providedSchema = builder.providedSchema;
            this.allowRequiredNullColumns = builder.allowRequiredNullColumns;
            this.limit = builder.limit < 0L ? Long.MAX_VALUE : builder.limit;
        }

        protected TupleMetadata providedSchema() {
            return this.providedSchema;
        }
    }

    public static abstract class ScanOrchestratorBuilder {
        private TypeProtos.MajorType nullType;
        private MetadataManager metadataManager;
        private int scanBatchRecordLimit = 4096;
        private int scanBatchByteLimit = DEFAULT_BATCH_BYTE_COUNT;
        private final List<ScanLevelProjection.ScanProjectionParser> parsers = new ArrayList<ScanLevelProjection.ScanProjectionParser>();
        private final List<ReaderLevelProjection.ReaderProjectionResolver> schemaResolvers = new ArrayList<ReaderLevelProjection.ReaderProjectionResolver>();
        private boolean useSchemaSmoothing;
        private boolean allowRequiredNullColumns;
        private List<SchemaPath> projection;
        private TupleMetadata providedSchema;
        private boolean enableSchemaBatch;
        public boolean disableEmptyResults;
        private CustomErrorContext errorContext;
        private long limit = -1L;

        public void withImplicitColumns(MetadataManager metadataMgr) {
            this.metadataManager = metadataMgr;
            this.schemaResolvers.add(this.metadataManager.resolver());
        }

        public void batchRecordLimit(int batchRecordLimit) {
            this.scanBatchRecordLimit = Math.max(1, Math.min(batchRecordLimit, 65536));
        }

        public void batchByteLimit(int byteLimit) {
            this.scanBatchByteLimit = Math.max(262144, Math.min(byteLimit, Integer.MAX_VALUE));
        }

        public void nullType(TypeProtos.MajorType nullType) {
            this.nullType = nullType;
        }

        public void enableSchemaSmoothing(boolean flag) {
            this.useSchemaSmoothing = flag;
        }

        public void allowRequiredNullColumns(boolean flag) {
            this.allowRequiredNullColumns = flag;
        }

        public void addParser(ScanLevelProjection.ScanProjectionParser parser) {
            this.parsers.add(parser);
        }

        public void addResolver(ReaderLevelProjection.ReaderProjectionResolver resolver) {
            this.schemaResolvers.add(resolver);
        }

        public void projection(List<SchemaPath> projection) {
            this.projection = projection;
        }

        public void enableSchemaBatch(boolean option) {
            this.enableSchemaBatch = option;
        }

        public void disableEmptyResults(boolean option) {
            this.disableEmptyResults = option;
        }

        public void providedSchema(TupleMetadata providedSchema) {
            this.providedSchema = providedSchema;
        }

        public TupleMetadata providedSchema() {
            return this.providedSchema;
        }

        public void limit(long limit) {
            this.limit = Math.max(-1L, limit);
        }

        public long limit() {
            return this.limit;
        }

        public void errorContext(CustomErrorContext context) {
            this.errorContext = context;
        }

        public CustomErrorContext errorContext() {
            return this.errorContext;
        }

        @VisibleForTesting
        public ScanOperatorExec buildScan() {
            return new ScanOperatorExec(this.buildEvents(), !this.disableEmptyResults);
        }

        public OperatorRecordBatch buildScanOperator(FragmentContext fragContext, PhysicalOperator pop) {
            return new OperatorRecordBatch(fragContext, pop, this.buildScan(), this.enableSchemaBatch);
        }

        public abstract ScanOperatorEvents buildEvents();
    }
}

