/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.physical.impl.scan.project;

import java.util.List;
import org.apache.drill.exec.physical.impl.scan.project.ReaderLevelProjection;
import org.apache.drill.exec.physical.impl.scan.project.ResolvedTuple;
import org.apache.drill.exec.physical.impl.scan.project.ScanLevelProjection;
import org.apache.drill.exec.physical.impl.scan.project.SmoothingProjection;
import org.apache.drill.exec.physical.impl.scan.project.WildcardProjection;
import org.apache.drill.exec.record.metadata.TupleMetadata;

public class SchemaSmoother {
    private final ScanLevelProjection scanProj;
    private final List<ReaderLevelProjection.ReaderProjectionResolver> resolvers;
    private ResolvedTuple priorSchema;
    private int schemaVersion = 0;

    public SchemaSmoother(ScanLevelProjection scanProj, List<ReaderLevelProjection.ReaderProjectionResolver> resolvers) {
        this.scanProj = scanProj;
        this.resolvers = resolvers;
    }

    public ReaderLevelProjection resolve(TupleMetadata tableSchema, ResolvedTuple outputTuple) {
        if (this.priorSchema != null) {
            try {
                SmoothingProjection smoother = new SmoothingProjection(this.scanProj, tableSchema, this.priorSchema, outputTuple, this.resolvers);
                this.priorSchema = outputTuple;
                return smoother;
            }
            catch (IncompatibleSchemaException e) {
                outputTuple.reset();
            }
        }
        WildcardProjection schemaProj = new WildcardProjection(this.scanProj, tableSchema, outputTuple, this.resolvers);
        this.priorSchema = outputTuple;
        ++this.schemaVersion;
        return schemaProj;
    }

    public int schemaVersion() {
        return this.schemaVersion;
    }

    public static class IncompatibleSchemaException
    extends Exception {
    }
}

