/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.physical.impl.scan.project;

import java.util.ArrayList;
import java.util.List;
import org.apache.drill.common.types.TypeProtos;
import org.apache.drill.exec.physical.impl.scan.project.ReaderLevelProjection;
import org.apache.drill.exec.physical.impl.scan.project.ResolvedColumn;
import org.apache.drill.exec.physical.impl.scan.project.ResolvedNullColumn;
import org.apache.drill.exec.physical.impl.scan.project.ResolvedTableColumn;
import org.apache.drill.exec.physical.impl.scan.project.ResolvedTuple;
import org.apache.drill.exec.physical.impl.scan.project.ScanLevelProjection;
import org.apache.drill.exec.physical.impl.scan.project.SchemaSmoother;
import org.apache.drill.exec.record.MaterializedField;
import org.apache.drill.exec.record.metadata.TupleMetadata;

public class SmoothingProjection
extends ReaderLevelProjection {
    protected final List<MaterializedField> rewrittenFields = new ArrayList<MaterializedField>();

    public SmoothingProjection(ScanLevelProjection scanProj, TupleMetadata tableSchema, ResolvedTuple priorSchema, ResolvedTuple outputTuple, List<ReaderLevelProjection.ReaderProjectionResolver> resolvers) throws SchemaSmoother.IncompatibleSchemaException {
        super(resolvers);
        for (ResolvedColumn priorCol : priorSchema.columns()) {
            if (priorCol instanceof ResolvedTableColumn || priorCol instanceof ResolvedNullColumn) {
                this.resolveColumn(outputTuple, priorCol, tableSchema);
                continue;
            }
            this.resolveSpecial(outputTuple, priorCol, tableSchema);
        }
        if (this.rewrittenFields.size() < tableSchema.size()) {
            throw new SchemaSmoother.IncompatibleSchemaException();
        }
    }

    private void resolveColumn(ResolvedTuple outputTuple, ResolvedColumn priorCol, TupleMetadata tableSchema) throws SchemaSmoother.IncompatibleSchemaException {
        MaterializedField priorField;
        int tableColIndex = tableSchema.index(priorCol.name());
        if (tableColIndex == -1) {
            this.resolveNullColumn(outputTuple, priorCol);
            return;
        }
        MaterializedField tableCol = tableSchema.column(tableColIndex);
        if (!tableCol.isPromotableTo(priorField = priorCol.schema(), false)) {
            throw new SchemaSmoother.IncompatibleSchemaException();
        }
        outputTuple.add(new ResolvedTableColumn(priorCol.name(), priorField, outputTuple, tableColIndex));
        this.rewrittenFields.add(priorField);
    }

    private void resolveNullColumn(ResolvedTuple outputTuple, ResolvedColumn priorCol) throws SchemaSmoother.IncompatibleSchemaException {
        if (priorCol.schema().getType().getMode() == TypeProtos.DataMode.REQUIRED) {
            throw new SchemaSmoother.IncompatibleSchemaException();
        }
        outputTuple.add(outputTuple.nullBuilder().add(priorCol.name(), priorCol.schema().getType()));
    }

    public List<MaterializedField> revisedTableSchema() {
        return this.rewrittenFields;
    }
}

