/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.physical.impl.scan.project;

import java.util.List;
import org.apache.drill.exec.physical.impl.scan.project.AbstractUnresolvedColumn;
import org.apache.drill.exec.physical.impl.scan.project.ColumnProjection;
import org.apache.drill.exec.physical.impl.scan.project.ReaderLevelProjection;
import org.apache.drill.exec.physical.impl.scan.project.ResolvedTableColumn;
import org.apache.drill.exec.physical.impl.scan.project.ResolvedTuple;
import org.apache.drill.exec.physical.impl.scan.project.ScanLevelProjection;
import org.apache.drill.exec.record.MaterializedField;
import org.apache.drill.exec.record.metadata.TupleMetadata;

public class WildcardProjection
extends ReaderLevelProjection {
    public WildcardProjection(ScanLevelProjection scanProj, TupleMetadata tableSchema, ResolvedTuple rootTuple, List<ReaderLevelProjection.ReaderProjectionResolver> resolvers) {
        super(resolvers);
        for (ColumnProjection col : scanProj.columns()) {
            if (col instanceof AbstractUnresolvedColumn.UnresolvedWildcardColumn) {
                this.projectAllColumns(rootTuple, tableSchema);
                continue;
            }
            this.resolveSpecial(rootTuple, col, tableSchema);
        }
    }

    private void projectAllColumns(ResolvedTuple rootTuple, TupleMetadata tableSchema) {
        for (int i = 0; i < tableSchema.size(); ++i) {
            MaterializedField colSchema = tableSchema.column(i);
            rootTuple.add(new ResolvedTableColumn(colSchema.getName(), colSchema, rootTuple, i));
        }
    }
}

