/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.physical.impl.scan.v3;

import org.apache.drill.common.exceptions.CustomErrorContext;
import org.apache.drill.common.exceptions.UserException;
import org.apache.drill.common.types.TypeProtos;
import org.apache.drill.exec.physical.impl.scan.convert.StandardConversions;
import org.apache.drill.exec.physical.impl.scan.v3.SchemaNegotiator;
import org.apache.drill.exec.physical.resultSet.ResultSetLoader;
import org.apache.drill.exec.physical.resultSet.RowSetLoader;
import org.apache.drill.exec.record.metadata.ColumnMetadata;
import org.apache.drill.exec.record.metadata.MetadataUtils;
import org.apache.drill.exec.record.metadata.TupleMetadata;
import org.apache.drill.exec.record.metadata.TupleNameSpace;
import org.apache.drill.exec.record.metadata.TupleSchema;
import org.apache.drill.exec.vector.accessor.ScalarWriter;
import org.apache.drill.exec.vector.accessor.ValueWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FixedReceiver {
    private static final Logger logger = LoggerFactory.getLogger(FixedReceiver.class);
    private final RowSetLoader rowWriter;
    private final TupleNameSpace<ValueWriter> writers;

    private FixedReceiver(RowSetLoader rowWriter, TupleNameSpace<ValueWriter> writers) {
        this.rowWriter = rowWriter;
        this.writers = writers;
    }

    public static Builder builderFor(SchemaNegotiator negotiator) {
        return new Builder(negotiator);
    }

    public boolean start() {
        return this.rowWriter.start();
    }

    public ValueWriter scalar(int index) {
        return this.writers.get(index);
    }

    public ValueWriter scalar(String name) {
        return this.writers.get(name);
    }

    public void save() {
        this.rowWriter.save();
    }

    public RowSetLoader rowWriter() {
        return this.rowWriter;
    }

    public static class Builder {
        private final SchemaNegotiator negotiator;
        private final TupleMetadata providedSchema;
        private final StandardConversions.Builder conversionBuilder = StandardConversions.builder();
        private boolean isComplete;
        private RowSetLoader rowWriter;

        public Builder(SchemaNegotiator negotiator) {
            this.negotiator = negotiator;
            this.providedSchema = negotiator.providedSchema();
        }

        public StandardConversions.Builder conversionBuilder() {
            return this.conversionBuilder;
        }

        public Builder schemaIsComplete() {
            this.isComplete = true;
            return this;
        }

        public FixedReceiver build(TupleMetadata readerSchema) {
            StandardConversions conversions = this.conversionBuilder.build();
            TupleMetadata writerSchema = Builder.mergeSchemas(this.negotiator.providedSchema(), readerSchema);
            this.negotiator.tableSchema(writerSchema);
            this.negotiator.schemaIsComplete(this.isComplete);
            ResultSetLoader loader = this.negotiator.build();
            this.rowWriter = loader.writer();
            TupleNameSpace<ValueWriter> writers = new TupleNameSpace<ValueWriter>();
            for (ColumnMetadata col : readerSchema) {
                writers.add(col.name(), this.writerFor(col, conversions));
            }
            return new FixedReceiver(this.rowWriter, writers);
        }

        public static TupleMetadata mergeSchemas(TupleMetadata providedSchema, TupleMetadata readerSchema) {
            if (providedSchema == null) {
                return readerSchema;
            }
            TupleSchema tableSchema = new TupleSchema();
            for (ColumnMetadata readerCol : readerSchema) {
                ColumnMetadata providedCol = providedSchema.metadata(readerCol.name());
                tableSchema.addColumn(providedCol == null ? readerCol : providedCol);
            }
            if (providedSchema.hasProperties()) {
                tableSchema.properties().putAll(providedSchema.properties());
            }
            return tableSchema;
        }

        private ValueWriter writerFor(ColumnMetadata readerCol, StandardConversions conversions) {
            if (!MetadataUtils.isScalar(readerCol)) {
                throw UserException.internalError().message("FixedReceiver only works with scalar columns, reader column is not scalar", new Object[0]).addContext("Column name", readerCol.name()).addContext("Column type", readerCol.type().name()).addContext(this.errorContext()).build(logger);
            }
            ScalarWriter baseWriter = this.rowWriter.scalar(readerCol.name());
            if (!this.rowWriter.isProjected(readerCol.name())) {
                return baseWriter;
            }
            ColumnMetadata providedCol = this.providedCol(readerCol.name());
            if (providedCol == null) {
                return baseWriter;
            }
            if (!MetadataUtils.isScalar(providedCol)) {
                throw UserException.validationError().message("FixedReceiver only works with scalar columns, provided column is not scalar", new Object[0]).addContext("Provided column name", providedCol.name()).addContext("Provided column type", providedCol.type().name()).addContext(this.errorContext()).build(logger);
            }
            if (!this.compatibleModes(readerCol.mode(), providedCol.mode())) {
                throw UserException.validationError().message("Reader and provided columns have incompatible cardinality", new Object[0]).addContext("Column name", providedCol.name()).addContext("Provided column mode", providedCol.mode().name()).addContext("Reader column mode", readerCol.mode().name()).addContext(this.errorContext()).build(logger);
            }
            return conversions.converterFor(baseWriter, readerCol.type());
        }

        private boolean compatibleModes(TypeProtos.DataMode source, TypeProtos.DataMode dest) {
            return source == dest || dest == TypeProtos.DataMode.OPTIONAL && source == TypeProtos.DataMode.REQUIRED;
        }

        private ColumnMetadata providedCol(String name) {
            return this.providedSchema == null ? null : this.providedSchema.metadata(name);
        }

        private CustomErrorContext errorContext() {
            return this.negotiator.errorContext();
        }
    }
}

