/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.physical.impl.scan.v3;

import java.util.Collections;
import java.util.List;
import org.apache.drill.common.exceptions.CustomErrorContext;
import org.apache.drill.common.exceptions.EmptyErrorContext;
import org.apache.drill.common.expression.SchemaPath;
import org.apache.drill.common.types.TypeProtos;
import org.apache.drill.exec.ops.FragmentContext;
import org.apache.drill.exec.ops.OperatorContext;
import org.apache.drill.exec.physical.base.PhysicalOperator;
import org.apache.drill.exec.physical.impl.protocol.OperatorRecordBatch;
import org.apache.drill.exec.physical.impl.scan.ScanOperatorExec;
import org.apache.drill.exec.physical.impl.scan.v3.ManagedReader;
import org.apache.drill.exec.physical.impl.scan.v3.ReaderFactory;
import org.apache.drill.exec.physical.impl.scan.v3.SchemaNegotiator;
import org.apache.drill.exec.physical.impl.scan.v3.lifecycle.ScanEventListener;
import org.apache.drill.exec.physical.impl.scan.v3.lifecycle.ScanLifecycle;
import org.apache.drill.exec.physical.impl.scan.v3.schema.ScanSchemaTracker;
import org.apache.drill.exec.record.metadata.TupleMetadata;
import org.apache.drill.exec.server.options.OptionSet;
import org.apache.drill.exec.vector.ValueVector;
import org.apache.drill.shaded.guava.com.google.common.annotations.VisibleForTesting;

public class ScanLifecycleBuilder {
    public static final int MIN_BATCH_BYTE_SIZE = 262144;
    public static final int MAX_BATCH_BYTE_SIZE = Integer.MAX_VALUE;
    public static final int DEFAULT_BATCH_ROW_COUNT = 4096;
    public static final int DEFAULT_BATCH_BYTE_COUNT = ValueVector.MAX_BUFFER_SIZE;
    public static final int MAX_BATCH_ROW_COUNT = 65536;
    private OptionSet options;
    private ReaderFactory<?> readerFactory;
    protected String userName;
    protected TypeProtos.MajorType nullType;
    private int scanBatchRecordLimit = 4096;
    private int scanBatchByteLimit = DEFAULT_BATCH_BYTE_COUNT;
    protected boolean allowRequiredNullColumns;
    private List<SchemaPath> projection;
    protected TupleMetadata definedSchema;
    protected TupleMetadata providedSchema;
    protected boolean enableSchemaBatch;
    protected boolean disableEmptyResults;
    protected boolean allowSchemaChange = true;
    protected SchemaValidator schemaValidator;
    protected CustomErrorContext errorContext;
    private long limit = Long.MAX_VALUE;

    public void options(OptionSet options) {
        this.options = options;
    }

    public OptionSet options() {
        return this.options;
    }

    public void readerFactory(ReaderFactory<?> readerFactory) {
        this.readerFactory = readerFactory;
    }

    public void userName(String userName) {
        this.userName = userName;
    }

    public String userName() {
        return this.userName;
    }

    public void batchRecordLimit(int batchRecordLimit) {
        this.scanBatchRecordLimit = Math.max(1, Math.min(batchRecordLimit, 65536));
    }

    public void batchByteLimit(int byteLimit) {
        this.scanBatchByteLimit = Math.max(262144, Math.min(byteLimit, Integer.MAX_VALUE));
    }

    public void nullType(TypeProtos.MajorType nullType) {
        this.nullType = nullType;
    }

    public void allowRequiredNullColumns(boolean flag) {
        this.allowRequiredNullColumns = flag;
    }

    public boolean allowRequiredNullColumns() {
        return this.allowRequiredNullColumns;
    }

    public void allowSchemaChange(boolean flag) {
        this.allowSchemaChange = flag;
    }

    public boolean allowSchemaChange() {
        return this.allowSchemaChange;
    }

    public void projection(List<SchemaPath> projection) {
        this.projection = projection;
    }

    public void enableSchemaBatch(boolean option) {
        this.enableSchemaBatch = option;
    }

    public void disableEmptyResults(boolean option) {
        this.disableEmptyResults = option;
    }

    public void definedSchema(TupleMetadata definedSchema) {
        this.definedSchema = definedSchema;
    }

    public TupleMetadata definedSchema() {
        return this.definedSchema;
    }

    public void providedSchema(TupleMetadata providedSchema) {
        this.providedSchema = providedSchema;
    }

    public TupleMetadata providedSchema() {
        return this.providedSchema;
    }

    public void errorContext(CustomErrorContext context) {
        this.errorContext = context;
    }

    public CustomErrorContext errorContext() {
        if (this.errorContext == null) {
            this.errorContext = new EmptyErrorContext();
        }
        return this.errorContext;
    }

    public List<SchemaPath> projection() {
        if (this.projection == null) {
            this.projection = Collections.singletonList(SchemaPath.STAR_COLUMN);
        }
        return this.projection;
    }

    public int scanBatchRecordLimit() {
        return Math.max(1, Math.min(this.scanBatchRecordLimit, 65536));
    }

    public int scanBatchByteLimit() {
        return Math.max(262144, Math.min(this.scanBatchByteLimit, Integer.MAX_VALUE));
    }

    public TypeProtos.MajorType nullType() {
        return this.nullType;
    }

    public ReaderFactory<?> readerFactory() {
        if (this.readerFactory == null) {
            this.readerFactory = new DummyReaderFactory();
        }
        return this.readerFactory;
    }

    public void schemaValidator(SchemaValidator schemaValidator) {
        this.schemaValidator = schemaValidator;
    }

    public SchemaValidator schemaValidator() {
        return this.schemaValidator;
    }

    public void limit(long limit) {
        this.limit = limit < 0L ? Long.MAX_VALUE : limit;
    }

    public long limit() {
        return this.limit;
    }

    public ScanLifecycle build(OperatorContext context) {
        return new ScanLifecycle(context, this);
    }

    @VisibleForTesting
    public ScanOperatorExec buildScan() {
        return new ScanOperatorExec(new ScanEventListener(this), !this.disableEmptyResults);
    }

    public OperatorRecordBatch buildScanOperator(FragmentContext fragContext, PhysicalOperator pop) {
        return new OperatorRecordBatch(fragContext, pop, this.buildScan(), this.enableSchemaBatch);
    }

    public static class DummyReaderFactory
    implements ReaderFactory<SchemaNegotiator> {
        @Override
        public boolean hasNext() {
            return false;
        }

        @Override
        public ManagedReader next(SchemaNegotiator negotiator) {
            return null;
        }
    }

    public static interface SchemaValidator {
        public void validate(ScanSchemaTracker var1);
    }
}

