/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.physical.impl.scan.v3.file;

import java.io.IOException;
import org.apache.drill.common.exceptions.UserException;
import org.apache.drill.exec.ops.OperatorContext;
import org.apache.drill.exec.physical.impl.scan.v3.file.FileReaderFactory;
import org.apache.drill.exec.physical.impl.scan.v3.file.FileScanLifecycleBuilder;
import org.apache.drill.exec.physical.impl.scan.v3.file.FileSchemaNegotiatorImpl;
import org.apache.drill.exec.physical.impl.scan.v3.file.ImplicitFileColumnsHandler;
import org.apache.drill.exec.physical.impl.scan.v3.lifecycle.ReaderLifecycle;
import org.apache.drill.exec.physical.impl.scan.v3.lifecycle.ScanLifecycle;
import org.apache.drill.exec.physical.impl.scan.v3.lifecycle.SchemaNegotiatorImpl;
import org.apache.drill.exec.store.dfs.DrillFileSystem;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileScanLifecycle
extends ScanLifecycle {
    private static final Logger logger = LoggerFactory.getLogger(FileScanLifecycle.class);
    private final DrillFileSystem dfs;
    private final ImplicitFileColumnsHandler implicitColumnsHandler;

    public FileScanLifecycle(OperatorContext context, FileScanLifecycleBuilder options) {
        super(context, options);
        try {
            this.dfs = context.newFileSystem(options.fileSystemConfig());
        }
        catch (IOException e) {
            throw UserException.dataReadError(e).addContext("Failed to create FileSystem").addContext(options.errorContext()).build(logger);
        }
        this.implicitColumnsHandler = new ImplicitFileColumnsHandler(this.dfs, context.getFragmentContext().getOptions(), options, this.vectorCache(), this.schemaTracker());
        FileReaderFactory readerFactory = (FileReaderFactory)this.readerFactory();
        readerFactory.bind(this);
    }

    public FileScanLifecycleBuilder fileScanOptions() {
        return (FileScanLifecycleBuilder)this.options();
    }

    public DrillFileSystem fileSystem() {
        return this.dfs;
    }

    public ImplicitFileColumnsHandler implicitColumnsHandler() {
        return this.implicitColumnsHandler;
    }

    @Override
    protected SchemaNegotiatorImpl newNegotiator(ReaderLifecycle readerLifecycle) {
        return new FileSchemaNegotiatorImpl(readerLifecycle);
    }

    @Override
    public void close() {
        super.close();
        try {
            this.dfs.close();
        }
        catch (IOException e) {
            logger.warn("Failed to close the Drill file system", (Throwable)e);
        }
    }
}

