/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.physical.impl.scan.v3.file;

import org.apache.drill.common.exceptions.ChildErrorContext;
import org.apache.drill.common.exceptions.CustomErrorContext;
import org.apache.drill.common.exceptions.UserException;
import org.apache.drill.exec.physical.impl.scan.v3.ManagedReader;
import org.apache.drill.exec.physical.impl.scan.v3.ReaderFactory;
import org.apache.drill.exec.physical.impl.scan.v3.file.FileDescrip;
import org.apache.drill.exec.physical.impl.scan.v3.file.FileScanLifecycle;
import org.apache.drill.exec.physical.impl.scan.v3.file.FileSchemaNegotiator;
import org.apache.drill.exec.physical.impl.scan.v3.file.ImplicitFileColumnsHandler;
import org.apache.drill.exec.physical.impl.scan.v3.lifecycle.ReaderLifecycle;
import org.apache.drill.exec.physical.impl.scan.v3.lifecycle.SchemaNegotiatorImpl;
import org.apache.drill.exec.physical.impl.scan.v3.lifecycle.StaticBatchBuilder;
import org.apache.drill.exec.physical.resultSet.ResultSetLoader;
import org.apache.drill.exec.store.dfs.easy.FileWork;
import org.apache.hadoop.mapred.FileSplit;

public class FileSchemaNegotiatorImpl
extends SchemaNegotiatorImpl
implements FileSchemaNegotiator {
    private FileDescrip fileDescrip;

    public FileSchemaNegotiatorImpl(ReaderLifecycle readerLifecycle) {
        super(readerLifecycle);
        this.readerErrorContext = this.baseErrorContext = new SplitErrorContext(this.baseErrorContext);
    }

    public void bindSplit(FileWork fileWork) {
        this.fileDescrip = this.fileScan().implicitColumnsHandler().makeDescrip(fileWork);
    }

    @Override
    public FileDescrip file() {
        return this.fileDescrip;
    }

    @Override
    public ManagedReader newReader(ReaderFactory<?> readerFactory) throws ManagedReader.EarlyEofException {
        return readerFactory.next(this);
    }

    @Override
    public StaticBatchBuilder implicitColumnsLoader() {
        return this.fileScan().implicitColumnsHandler().forFile(this.fileDescrip);
    }

    private FileScanLifecycle fileScan() {
        return (FileScanLifecycle)this.readerLifecycle.scanLifecycle();
    }

    @Override
    protected void onEndBatch() {
        ImplicitFileColumnsHandler handler = this.fileScan().implicitColumnsHandler();
        if (!handler.isMetadataScan()) {
            return;
        }
        ResultSetLoader tableLoader = this.readerLifecycle.tableLoader();
        if (tableLoader.batchCount() == 0 && !tableLoader.hasRows()) {
            tableLoader.writer().start();
            tableLoader.writer().save();
            this.fileDescrip.markEmpty();
        }
    }

    public class SplitErrorContext
    extends ChildErrorContext {
        public SplitErrorContext(CustomErrorContext parent) {
            super(parent);
        }

        @Override
        public void addContext(UserException.Builder builder) {
            super.addContext(builder);
            FileSplit split = FileSchemaNegotiatorImpl.this.fileDescrip.split();
            builder.addContext("File", split.getPath().toString());
            if (split.getStart() != 0L) {
                builder.addContext("Offset", split.getStart());
                builder.addContext("Length", split.getLength());
            }
        }
    }
}

