/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.physical.impl.scan.v3.file;

import org.apache.drill.exec.physical.impl.scan.v3.file.FileDescrip;
import org.apache.drill.exec.store.ColumnExplorer;

public abstract class ImplicitColumnMarker {
    private int index = -1;

    public void setIndex(int index) {
        this.index = index;
    }

    public int index() {
        return this.index;
    }

    public abstract String resolve(FileDescrip var1);

    public static class InternalColumnMarker
    extends ImplicitColumnMarker {
        public final ColumnExplorer.ImplicitInternalFileColumns defn;

        public InternalColumnMarker(ColumnExplorer.ImplicitInternalFileColumns defn) {
            this.defn = defn;
        }

        @Override
        public String resolve(FileDescrip fileInfo) {
            switch (this.defn) {
                case ROW_GROUP_INDEX: {
                    return this.valueOf(fileInfo.rowGroupIndex);
                }
                case ROW_GROUP_START: {
                    return this.valueOf(fileInfo.rowGroupStart);
                }
                case ROW_GROUP_LENGTH: {
                    return this.valueOf(fileInfo.rowGroupLength);
                }
                case PROJECT_METADATA: 
                case USE_METADATA: {
                    return fileInfo.isEmpty ? Boolean.FALSE.toString() : null;
                }
                case LAST_MODIFIED_TIME: {
                    return fileInfo.getModTime();
                }
            }
            throw new IllegalStateException(this.defn.name());
        }

        private String valueOf(Object value) {
            return value == null ? null : String.valueOf(value);
        }

        public String toString() {
            return this.defn.name();
        }
    }

    public static class PartitionColumnMarker
    extends ImplicitColumnMarker {
        private final int partition;

        public PartitionColumnMarker(int partition) {
            this.partition = partition;
        }

        @Override
        public String resolve(FileDescrip fileInfo) {
            return fileInfo.partition(this.partition);
        }

        public String toString() {
            return "dir" + this.partition;
        }
    }

    public static class FileImplicitMarker
    extends ImplicitColumnMarker {
        public final ColumnExplorer.ImplicitFileColumns defn;

        public FileImplicitMarker(ColumnExplorer.ImplicitFileColumns defn) {
            this.defn = defn;
        }

        @Override
        public String resolve(FileDescrip fileInfo) {
            return this.defn.getValue(fileInfo.filePath());
        }

        public String toString() {
            return this.defn.name();
        }
    }
}

