/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.physical.impl.scan.v3.lifecycle;

import org.apache.drill.common.types.TypeProtos;
import org.apache.drill.exec.physical.impl.scan.v3.lifecycle.StaticBatchBuilder;
import org.apache.drill.exec.physical.resultSet.ResultVectorCache;
import org.apache.drill.exec.record.metadata.ColumnMetadata;
import org.apache.drill.exec.record.metadata.MetadataUtils;
import org.apache.drill.exec.record.metadata.TupleMetadata;
import org.apache.drill.exec.record.metadata.TupleSchema;

public class MissingColumnHandlerBuilder {
    public static final TypeProtos.MajorType DEFAULT_NULL_TYPE = TypeProtos.MajorType.newBuilder().setMinorType(TypeProtos.MinorType.INT).setMode(TypeProtos.DataMode.OPTIONAL).build();
    protected TupleMetadata inputSchema;
    protected TypeProtos.MajorType nullType;
    protected boolean allowRequiredNullColumns;
    protected ResultVectorCache vectorCache;
    protected TupleMetadata outputSchema;

    public MissingColumnHandlerBuilder inputSchema(TupleMetadata inputSchema) {
        this.inputSchema = inputSchema;
        return this;
    }

    public MissingColumnHandlerBuilder nullType(TypeProtos.MajorType nullType) {
        this.nullType = nullType;
        return this;
    }

    public MissingColumnHandlerBuilder allowRequiredNullColumns(boolean flag) {
        this.allowRequiredNullColumns = flag;
        return this;
    }

    public MissingColumnHandlerBuilder vectorCache(ResultVectorCache vectorCache) {
        this.vectorCache = vectorCache;
        return this;
    }

    public TupleMetadata buildSchema() {
        if (this.inputSchema == null || this.inputSchema.isEmpty()) {
            return null;
        }
        this.outputSchema = new TupleSchema();
        TypeProtos.MajorType selectedNullType = this.nullType == null ? DEFAULT_NULL_TYPE : this.nullType;
        for (ColumnMetadata inputCol : this.inputSchema) {
            if (inputCol.isDynamic()) {
                this.outputSchema.addColumn(MetadataUtils.newScalar(inputCol.name(), selectedNullType));
                continue;
            }
            this.outputSchema.addColumn(inputCol);
        }
        return this.outputSchema;
    }

    public StaticBatchBuilder build() {
        this.buildSchema();
        if (this.outputSchema == null) {
            return null;
        }
        return new StaticBatchBuilder.NullBatchBuilder(this.vectorCache, this.outputSchema);
    }
}

