/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.physical.impl.scan.v3.schema;

import org.apache.drill.common.exceptions.CustomErrorContext;
import org.apache.drill.exec.physical.impl.scan.v3.file.ImplicitColumnMarker;
import org.apache.drill.exec.physical.impl.scan.v3.schema.AbstractSchemaTracker;
import org.apache.drill.exec.physical.impl.scan.v3.schema.DynamicSchemaFilter;
import org.apache.drill.exec.physical.impl.scan.v3.schema.ProjectedColumn;
import org.apache.drill.exec.physical.impl.scan.v3.schema.ScanProjectionParser;
import org.apache.drill.exec.physical.impl.scan.v3.schema.ScanSchemaResolver;
import org.apache.drill.exec.physical.impl.scan.v3.schema.ScanSchemaTracker;
import org.apache.drill.exec.physical.impl.scan.v3.schema.SchemaUtils;
import org.apache.drill.exec.physical.resultSet.impl.ProjectionFilter;
import org.apache.drill.exec.record.metadata.ColumnMetadata;
import org.apache.drill.exec.record.metadata.TupleMetadata;

public class ProjectionSchemaTracker
extends AbstractSchemaTracker {
    private final TupleMetadata projection;
    private final boolean allowSchemaChange;
    private int implicitInsertPoint;
    private int readerSchemaCount;
    private boolean allowMapAdditions = true;

    public ProjectionSchemaTracker(TupleMetadata definedSchema, ScanProjectionParser.ProjectionParseResult parseResult, CustomErrorContext errorContext) {
        super(errorContext);
        this.projection = parseResult.dynamicSchema;
        this.allowSchemaChange = false;
        this.schema.copyFrom(definedSchema);
        ProjectionSchemaTracker.validateProjection(parseResult.dynamicSchema, definedSchema);
        ScanSchemaTracker.ProjectionType projType = this.schema.size() == 0 ? ScanSchemaTracker.ProjectionType.NONE : ScanSchemaTracker.ProjectionType.SOME;
        this.schema.setProjectionType(projType);
        this.implicitInsertPoint = -1;
        this.checkResolved();
    }

    public ProjectionSchemaTracker(ScanProjectionParser.ProjectionParseResult parseResult, boolean allowSchemaChange, CustomErrorContext errorContext) {
        super(errorContext);
        ScanSchemaTracker.ProjectionType projType;
        this.projection = parseResult.dynamicSchema;
        this.allowSchemaChange = allowSchemaChange;
        this.schema.copyFrom(this.projection);
        if (parseResult.isProjectAll()) {
            projType = ScanSchemaTracker.ProjectionType.ALL;
        } else if (this.projection.isEmpty()) {
            projType = ScanSchemaTracker.ProjectionType.NONE;
            this.isResolved = true;
            this.allowMapAdditions = false;
        } else {
            projType = ScanSchemaTracker.ProjectionType.SOME;
        }
        this.schema.setProjectionType(projType);
        this.schema.setInsertPoint(parseResult.wildcardPosn);
        this.implicitInsertPoint = parseResult.wildcardPosn;
    }

    @Override
    public ProjectedColumn columnProjection(String colName) {
        return (ProjectedColumn)this.projection.metadata(colName);
    }

    public void applyProvidedSchema(TupleMetadata providedSchema) {
        boolean isStrict = SchemaUtils.isStrict(providedSchema);
        new ScanSchemaResolver(this.schema, isStrict ? ScanSchemaResolver.SchemaType.STRICT_PROVIDED_SCHEMA : ScanSchemaResolver.SchemaType.LENIENT_PROVIDED_SCHEMA, true, this.errorContext).applySchema(providedSchema);
        this.checkResolved();
        if (isStrict) {
            this.allowMapAdditions = false;
        }
    }

    @Override
    public void applyEarlyReaderSchema(TupleMetadata readerSchema) {
        new ScanSchemaResolver(this.schema, ScanSchemaResolver.SchemaType.EARLY_READER_SCHEMA, true, this.errorContext).applySchema(readerSchema);
        this.checkResolved();
    }

    @Override
    public ProjectionFilter projectionFilter(CustomErrorContext errorContext) {
        switch (this.projectionType()) {
            case ALL: {
                if (this.schema.size() != 0) break;
                return ProjectionFilter.PROJECT_ALL;
            }
            case NONE: {
                return ProjectionFilter.PROJECT_NONE;
            }
        }
        return new DynamicSchemaFilter.RowSchemaFilter(this.schema, this.allowMapAdditions, errorContext);
    }

    @Override
    public void applyReaderSchema(TupleMetadata readerOutputSchema, CustomErrorContext errorContext) {
        ScanSchemaResolver.SchemaType schemaType = this.readerSchemaCount == 0 && this.allowSchemaChange ? ScanSchemaResolver.SchemaType.FIRST_READER_SCHEMA : ScanSchemaResolver.SchemaType.READER_SCHEMA;
        new ScanSchemaResolver(this.schema, schemaType, this.allowMapAdditions, errorContext).applySchema(readerOutputSchema);
        if (!this.allowSchemaChange) {
            this.allowMapAdditions = false;
            if (this.projectionType() == ScanSchemaTracker.ProjectionType.ALL) {
                this.schema.setProjectionType(ScanSchemaTracker.ProjectionType.SOME);
            }
        }
        this.checkResolved();
        ++this.readerSchemaCount;
    }

    @Override
    public void expandImplicitCol(ColumnMetadata resolved, ImplicitColumnMarker marker) {
        this.schema.insert(this.implicitInsertPoint++, resolved).markImplicit(marker);
    }
}

