/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.physical.impl.scan.v3.schema;

import org.apache.drill.common.exceptions.CustomErrorContext;
import org.apache.drill.exec.physical.impl.scan.v3.file.ImplicitColumnMarker;
import org.apache.drill.exec.physical.impl.scan.v3.schema.AbstractSchemaTracker;
import org.apache.drill.exec.physical.impl.scan.v3.schema.DynamicSchemaFilter;
import org.apache.drill.exec.physical.impl.scan.v3.schema.ProjectedColumn;
import org.apache.drill.exec.physical.impl.scan.v3.schema.ScanSchemaTracker;
import org.apache.drill.exec.physical.resultSet.impl.ProjectionFilter;
import org.apache.drill.exec.record.metadata.ColumnMetadata;
import org.apache.drill.exec.record.metadata.TupleMetadata;
import org.apache.drill.shaded.guava.com.google.common.base.Preconditions;

public class SchemaBasedTracker
extends AbstractSchemaTracker {
    private final TupleMetadata definedSchema;

    public SchemaBasedTracker(TupleMetadata definedSchema, CustomErrorContext errorContext) {
        super(errorContext);
        this.definedSchema = definedSchema;
        this.schema.copyFrom(definedSchema);
        ScanSchemaTracker.ProjectionType projType = this.schema.size() == 0 ? ScanSchemaTracker.ProjectionType.NONE : ScanSchemaTracker.ProjectionType.SOME;
        this.schema.setProjectionType(projType);
        this.checkResolved();
        Preconditions.checkState(this.isResolved);
    }

    public void validateProjection(TupleMetadata projection) {
        if (projection != null) {
            SchemaBasedTracker.validateProjection(projection, this.definedSchema);
        }
    }

    @Override
    public void applyEarlyReaderSchema(TupleMetadata readerSchema) {
    }

    @Override
    public ProjectionFilter projectionFilter(CustomErrorContext errorContext) {
        switch (this.projectionType()) {
            case NONE: {
                return ProjectionFilter.PROJECT_NONE;
            }
            case SOME: {
                return new DynamicSchemaFilter.RowSchemaFilter(this.schema, false, errorContext);
            }
        }
        throw new IllegalStateException(this.projectionType().name());
    }

    @Override
    public void applyReaderSchema(TupleMetadata readerOutputSchema, CustomErrorContext errorContext) {
    }

    @Override
    public void expandImplicitCol(ColumnMetadata resolved, ImplicitColumnMarker marker) {
        throw new IllegalStateException("Can't expand a defined schema.");
    }

    @Override
    public int schemaVersion() {
        return 1;
    }

    @Override
    public ProjectedColumn columnProjection(String colName) {
        return null;
    }
}

