/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.physical.impl.setop;

import org.apache.calcite.sql.SqlKind;
import org.apache.drill.exec.exception.SchemaChangeException;
import org.apache.drill.exec.physical.config.SetOp;
import org.apache.drill.exec.physical.impl.common.HashPartition;
import org.apache.drill.exec.physical.impl.join.AbstractHashBinaryRecordBatch;
import org.apache.drill.exec.physical.impl.join.Probe;
import org.apache.drill.exec.physical.impl.join.ProbeTemplate;
import org.apache.drill.exec.physical.impl.setop.HashSetOpRecordBatch;
import org.apache.drill.exec.record.RecordBatch;
import org.apache.drill.exec.record.VectorContainer;

public class HashSetOpProbeTemplate
extends ProbeTemplate<SetOp> {
    private SqlKind opType;
    private boolean isAll;

    @Override
    public void setup(RecordBatch probeBatch, HashSetOpRecordBatch outgoing, SqlKind opType, boolean isAll, RecordBatch.IterOutcome leftStartState, HashPartition[] partitions, int cycleNum, VectorContainer container, AbstractHashBinaryRecordBatch.SpilledPartition[] spilledInners, boolean buildSideIsEmpty, int numPartitions) throws SchemaChangeException {
        super.setup(probeBatch, leftStartState, partitions, cycleNum, container, spilledInners, buildSideIsEmpty, numPartitions);
        this.outgoingBatch = outgoing;
        this.opType = opType;
        this.isAll = isAll;
        this.numberOfBuildSideColumns = 0;
    }

    @Override
    protected void handleProbeResult(int probeIndex) {
        switch (this.opType) {
            case INTERSECT: {
                if (probeIndex == -1 || this.currPartition.getRecordNumForKey(probeIndex) <= 0) break;
                if (this.isAll) {
                    this.currPartition.decreaseRecordNumForKey(probeIndex);
                } else {
                    this.currPartition.setRecordNumForKey(probeIndex, 0);
                }
                this.outputRecords = this.outputRow(null, 0, this.probeBatch.getContainer(), this.recordsProcessed);
                break;
            }
            case EXCEPT: {
                if (this.isAll) {
                    if (probeIndex == -1 || this.currPartition.getRecordNumForKey(probeIndex) == 0) {
                        this.outputRecords = this.outputRow(null, 0, this.probeBatch.getContainer(), this.recordsProcessed);
                        break;
                    }
                    this.currPartition.decreaseRecordNumForKey(probeIndex);
                    break;
                }
                if (probeIndex != -1) break;
                this.outputRecords = this.outputRow(null, 0, this.probeBatch.getContainer(), this.recordsProcessed);
            }
        }
        ++this.recordsProcessed;
    }

    @Override
    public void changeToFinalProbeState() {
        this.probeState = Probe.ProbeState.DONE;
    }

    public String toString() {
        return "HashSetOpProbeTemplate[container=" + this.container + ", probeSchema=" + this.probeSchema + ", opType=" + this.opType + ", isAll=" + this.isAll + ", recordsToProcess=" + this.recordsToProcess + ", recordsProcessed=" + this.recordsProcessed + ", outputRecords=" + this.outputRecords + ", probeState=" + (Object)((Object)this.probeState) + "]";
    }
}

