/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.physical.impl.sort;

import java.util.ArrayList;
import java.util.List;
import org.apache.drill.exec.memory.BufferAllocator;
import org.apache.drill.exec.record.BatchSchema;
import org.apache.drill.exec.record.RecordBatch;
import org.apache.drill.exec.record.TransferPair;
import org.apache.drill.exec.record.VectorAccessible;
import org.apache.drill.exec.record.VectorContainer;
import org.apache.drill.exec.record.VectorWrapper;
import org.apache.drill.exec.record.selection.SelectionVector2;
import org.apache.drill.exec.vector.ValueVector;
import org.apache.drill.shaded.guava.com.google.common.collect.Lists;

public class RecordBatchData {
    private SelectionVector2 sv2;
    private int recordCount;
    VectorContainer container = new VectorContainer();

    public RecordBatchData(VectorAccessible batch, BufferAllocator allocator) {
        ArrayList<ValueVector> vectors = Lists.newArrayList();
        this.recordCount = batch.getRecordCount();
        this.sv2 = batch instanceof RecordBatch && batch.getSchema().getSelectionVectorMode() == BatchSchema.SelectionVectorMode.TWO_BYTE ? ((RecordBatch)batch).getSelectionVector2().clone() : null;
        for (VectorWrapper v : batch) {
            if (v.isHyper()) {
                throw new UnsupportedOperationException("Record batch data can't be created based on a hyper batch.");
            }
            TransferPair tp = v.getValueVector().getTransferPair(allocator);
            tp.transfer();
            vectors.add(tp.getTo());
        }
        this.container.addCollection(vectors);
        this.container.setRecordCount(this.recordCount);
        this.container.buildSchema(batch.getSchema().getSelectionVectorMode());
    }

    public int getRecordCount() {
        return this.recordCount;
    }

    public List<ValueVector> getVectors() {
        ArrayList<ValueVector> vectors = Lists.newArrayList();
        for (VectorWrapper<?> w : this.container) {
            vectors.add((ValueVector)w.getValueVector());
        }
        return vectors;
    }

    public void setSv2(SelectionVector2 sv2) {
        this.sv2 = sv2;
        this.recordCount = sv2.getCount();
        this.container.buildSchema(BatchSchema.SelectionVectorMode.TWO_BYTE);
    }

    public SelectionVector2 getSv2() {
        return this.sv2;
    }

    public VectorContainer getContainer() {
        return this.container;
    }

    public void clear() {
        if (this.sv2 != null) {
            this.sv2.clear();
        }
        this.container.clear();
    }
}

