/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.physical.impl.sort;

import com.sun.codemodel.JConditional;
import com.sun.codemodel.JExpr;
import com.sun.codemodel.JExpression;
import java.util.List;
import org.apache.calcite.rel.RelFieldCollation;
import org.apache.drill.common.expression.ErrorCollectorImpl;
import org.apache.drill.common.expression.LogicalExpression;
import org.apache.drill.common.logical.data.Order;
import org.apache.drill.exec.compile.sig.MappingSet;
import org.apache.drill.exec.exception.OutOfMemoryException;
import org.apache.drill.exec.exception.SchemaChangeException;
import org.apache.drill.exec.expr.ClassGenerator;
import org.apache.drill.exec.expr.CodeGenerator;
import org.apache.drill.exec.expr.ExpressionTreeMaterializer;
import org.apache.drill.exec.expr.fn.FunctionGenerationHelper;
import org.apache.drill.exec.ops.FragmentContext;
import org.apache.drill.exec.physical.config.Sort;
import org.apache.drill.exec.physical.impl.sort.SortRecordBatchBuilder;
import org.apache.drill.exec.physical.impl.sort.Sorter;
import org.apache.drill.exec.record.AbstractRecordBatch;
import org.apache.drill.exec.record.BatchSchema;
import org.apache.drill.exec.record.RecordBatch;
import org.apache.drill.exec.record.VectorAccessible;
import org.apache.drill.exec.record.WritableBatch;
import org.apache.drill.exec.record.selection.SelectionVector2;
import org.apache.drill.exec.record.selection.SelectionVector4;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SortBatch
extends AbstractRecordBatch<Sort> {
    private static final Logger logger = LoggerFactory.getLogger(SortBatch.class);
    private final MappingSet mainMapping = new MappingSet((String)null, null, ClassGenerator.DEFAULT_CONSTANT_MAP, ClassGenerator.DEFAULT_SCALAR_MAP);
    private final MappingSet leftMapping = new MappingSet("leftIndex", null, ClassGenerator.DEFAULT_CONSTANT_MAP, ClassGenerator.DEFAULT_SCALAR_MAP);
    private final MappingSet rightMapping = new MappingSet("rightIndex", null, ClassGenerator.DEFAULT_CONSTANT_MAP, ClassGenerator.DEFAULT_SCALAR_MAP);
    private final RecordBatch incoming;
    private final SortRecordBatchBuilder builder;
    private Sorter sorter;
    private BatchSchema schema;

    public SortBatch(Sort popConfig, FragmentContext context, RecordBatch incoming) throws OutOfMemoryException {
        super(popConfig, context);
        this.incoming = incoming;
        this.builder = new SortRecordBatchBuilder(this.oContext.getAllocator());
    }

    @Override
    public int getRecordCount() {
        return this.builder.getSv4().getCount();
    }

    @Override
    public SelectionVector2 getSelectionVector2() {
        throw new UnsupportedOperationException();
    }

    @Override
    public SelectionVector4 getSelectionVector4() {
        return this.builder.getSv4();
    }

    @Override
    public void close() {
        this.builder.clear();
        this.builder.close();
        super.close();
    }

    @Override
    public RecordBatch.IterOutcome innerNext() {
        if (this.schema != null) {
            if (this.getSelectionVector4().next()) {
                return RecordBatch.IterOutcome.OK;
            }
            return RecordBatch.IterOutcome.NONE;
        }
        block8: while (true) {
            RecordBatch.IterOutcome upstream = this.incoming.next();
            switch (upstream) {
                case NONE: {
                    break block8;
                }
                case NOT_YET: {
                    throw new UnsupportedOperationException();
                }
                case OK_NEW_SCHEMA: {
                    if (!this.incoming.getSchema().equals(this.schema)) {
                        if (this.schema != null) {
                            throw new UnsupportedOperationException("Sort doesn't currently support sorts with changing schemas.");
                        }
                        this.schema = this.incoming.getSchema();
                    }
                }
                case OK: {
                    if (this.builder.add(this.incoming)) continue block8;
                    throw new UnsupportedOperationException("Sort doesn't currently support doing an external sort.");
                }
                default: {
                    throw new UnsupportedOperationException();
                }
            }
            break;
        }
        if (this.schema == null || this.builder.isEmpty()) {
            return RecordBatch.IterOutcome.NONE;
        }
        this.builder.build(this.container);
        this.sorter = this.createNewSorter();
        try {
            this.sorter.setup(this.context, this.getSelectionVector4(), this.container);
        }
        catch (SchemaChangeException e) {
            throw this.schemaChangeException(e, logger);
        }
        this.sorter.sort(this.getSelectionVector4(), this.container);
        return RecordBatch.IterOutcome.OK_NEW_SCHEMA;
    }

    private Sorter createNewSorter() {
        return SortBatch.createNewSorter(this.context, ((Sort)this.popConfig).getOrderings(), this, this.mainMapping, this.leftMapping, this.rightMapping);
    }

    public static Sorter createNewSorter(FragmentContext context, List<Order.Ordering> orderings, VectorAccessible batch) {
        MappingSet mainMapping = new MappingSet((String)null, null, ClassGenerator.DEFAULT_CONSTANT_MAP, ClassGenerator.DEFAULT_SCALAR_MAP);
        MappingSet leftMapping = new MappingSet("leftIndex", null, ClassGenerator.DEFAULT_CONSTANT_MAP, ClassGenerator.DEFAULT_SCALAR_MAP);
        MappingSet rightMapping = new MappingSet("rightIndex", null, ClassGenerator.DEFAULT_CONSTANT_MAP, ClassGenerator.DEFAULT_SCALAR_MAP);
        return SortBatch.createNewSorter(context, orderings, batch, mainMapping, leftMapping, rightMapping);
    }

    public static Sorter createNewSorter(FragmentContext context, List<Order.Ordering> orderings, VectorAccessible batch, MappingSet mainMapping, MappingSet leftMapping, MappingSet rightMapping) {
        CodeGenerator<Sorter> cg = CodeGenerator.get(Sorter.TEMPLATE_DEFINITION, context.getOptions());
        ClassGenerator<Sorter> g = cg.getRoot();
        g.setMappingSet(mainMapping);
        for (Order.Ordering od : orderings) {
            ErrorCollectorImpl collector = new ErrorCollectorImpl();
            LogicalExpression expr = ExpressionTreeMaterializer.materialize(od.getExpr(), batch, collector, context.getFunctionRegistry());
            collector.reportErrors(logger);
            g.setMappingSet(leftMapping);
            ClassGenerator.HoldingContainer left = g.addExpr(expr, ClassGenerator.BlkCreateMode.FALSE);
            g.setMappingSet(rightMapping);
            ClassGenerator.HoldingContainer right = g.addExpr(expr, ClassGenerator.BlkCreateMode.FALSE);
            g.setMappingSet(mainMapping);
            LogicalExpression fh = FunctionGenerationHelper.getOrderingComparator(od.nullsSortHigh(), left, right, context.getFunctionRegistry());
            ClassGenerator.HoldingContainer out = g.addExpr(fh, ClassGenerator.BlkCreateMode.FALSE);
            JConditional jc = g.getEvalBlock()._if(out.getValue().ne(JExpr.lit((int)0)));
            if (od.getDirection() == RelFieldCollation.Direction.ASCENDING) {
                jc._then()._return((JExpression)out.getValue());
                continue;
            }
            jc._then()._return(out.getValue().minus());
        }
        g.getEvalBlock()._return(JExpr.lit((int)0));
        return context.getImplementationClass(cg);
    }

    @Override
    public WritableBatch getWritableBatch() {
        throw new UnsupportedOperationException("A sort batch is not writable.");
    }

    @Override
    protected void cancelIncoming() {
        this.incoming.cancel();
    }

    @Override
    public void dump() {
        logger.error("SortBatch[popConfig={}, container={}, sorter={}, schema={}]", new Object[]{this.popConfig, this.container, this.sorter, this.schema});
    }
}

