/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.physical.impl.sort;

import io.netty.buffer.DrillBuf;
import java.util.ArrayList;
import java.util.List;
import org.apache.drill.common.exceptions.DrillRuntimeException;
import org.apache.drill.common.exceptions.UserException;
import org.apache.drill.exec.memory.AllocationReservation;
import org.apache.drill.exec.memory.BaseAllocator;
import org.apache.drill.exec.memory.BufferAllocator;
import org.apache.drill.exec.physical.impl.sort.RecordBatchData;
import org.apache.drill.exec.record.BatchSchema;
import org.apache.drill.exec.record.MaterializedField;
import org.apache.drill.exec.record.VectorAccessible;
import org.apache.drill.exec.record.VectorContainer;
import org.apache.drill.exec.record.VectorWrapper;
import org.apache.drill.exec.record.selection.SelectionVector2;
import org.apache.drill.exec.record.selection.SelectionVector4;
import org.apache.drill.exec.vector.ValueVector;
import org.apache.drill.shaded.guava.com.google.common.collect.ArrayListMultimap;
import org.apache.drill.shaded.guava.com.google.common.collect.Lists;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SortRecordBatchBuilder
implements AutoCloseable {
    static final Logger logger = LoggerFactory.getLogger(SortRecordBatchBuilder.class);
    private final ArrayListMultimap<BatchSchema, RecordBatchData> batches = ArrayListMultimap.create();
    private int recordCount;
    private long runningBatches;
    private SelectionVector4 sv4;
    private final BufferAllocator allocator;
    final AllocationReservation reservation;

    public SortRecordBatchBuilder(BufferAllocator a) {
        this.allocator = a;
        this.reservation = a.newReservation();
    }

    private long getSize(VectorAccessible batch) {
        long bytes = 0L;
        for (VectorWrapper v : batch) {
            bytes += (long)v.getValueVector().getBufferSize();
        }
        return bytes;
    }

    public boolean add(VectorAccessible batch) {
        if (batch.getSchema().getSelectionVectorMode() == BatchSchema.SelectionVectorMode.FOUR_BYTE) {
            throw new UnsupportedOperationException("A sort cannot currently work against a sv4 batch.");
        }
        if (batch.getRecordCount() == 0 && this.batches.size() > 0) {
            return true;
        }
        long batchBytes = this.getSize(batch);
        if (batchBytes == 0L && this.batches.size() > 0) {
            return true;
        }
        if (this.runningBatches >= 65535L) {
            return false;
        }
        if (!this.reservation.add(batch.getRecordCount() * 4)) {
            return false;
        }
        RecordBatchData bd = new RecordBatchData(batch, this.allocator);
        ++this.runningBatches;
        this.batches.put((Object)batch.getSchema(), (Object)bd);
        this.recordCount += bd.getRecordCount();
        return true;
    }

    public void add(RecordBatchData rbd) {
        long batchBytes = this.getSize(rbd.getContainer());
        if (batchBytes == 0L && this.batches.size() > 0) {
            return;
        }
        if (this.runningBatches >= 65535L) {
            String errMsg = String.format("Tried to add more than %d number of batches.", 65535);
            logger.error(errMsg);
            throw new DrillRuntimeException(errMsg);
        }
        if (!this.reservation.add(rbd.getRecordCount() * 4)) {
            String errMsg = String.format("Failed to pre-allocate memory for SV. Existing recordCount*4 = %d, incoming batch recordCount*4 = %d", this.recordCount * 4, rbd.getRecordCount() * 4);
            logger.error(errMsg);
            throw new DrillRuntimeException(errMsg);
        }
        if (rbd.getRecordCount() == 0 && this.batches.size() > 0) {
            rbd.getContainer().zeroVectors();
            SelectionVector2 sv2 = rbd.getSv2();
            if (sv2 != null) {
                sv2.clear();
            }
            return;
        }
        ++this.runningBatches;
        this.batches.put((Object)rbd.getContainer().getSchema(), (Object)rbd);
        this.recordCount += rbd.getRecordCount();
    }

    public boolean isEmpty() {
        return this.batches.isEmpty();
    }

    public void build(VectorContainer outputContainer) {
        outputContainer.clear();
        if (this.batches.keySet().size() > 1) {
            throw UserException.validationError(null).message("Sort currently only supports a single schema.", new Object[0]).build(logger);
        }
        if (this.batches.size() > 65535) {
            throw UserException.internalError(null).message("Sort cannot work on more than %d batches at a time.", Character.valueOf('\uffff')).build(logger);
        }
        if (this.batches.keys().size() < 1) assert (false) : "Invalid to have an empty set of batches with no schemas.";
        DrillBuf svBuffer = this.reservation.allocateBuffer();
        if (svBuffer == null) {
            throw new OutOfMemoryError("Failed to allocate direct memory for SV4 vector in SortRecordBatchBuilder.");
        }
        this.sv4 = new SelectionVector4(svBuffer, this.recordCount, 65536);
        BatchSchema schema = (BatchSchema)this.batches.keySet().iterator().next();
        List data = this.batches.get((Object)schema);
        switch (schema.getSelectionVectorMode()) {
            case NONE: {
                int i;
                int index = 0;
                int recordBatchId = 0;
                for (Object d : data) {
                    i = 0;
                    while (i < ((RecordBatchData)d).getRecordCount()) {
                        this.sv4.set(index, recordBatchId, i);
                        ++i;
                        ++index;
                    }
                    ++recordBatchId;
                }
                break;
            }
            case TWO_BYTE: {
                int i;
                int index = 0;
                int recordBatchId = 0;
                for (Object d : data) {
                    i = 0;
                    while (i < ((RecordBatchData)d).getRecordCount()) {
                        this.sv4.set(index, recordBatchId, ((RecordBatchData)d).getSv2().getIndex(i));
                        ++i;
                        ++index;
                    }
                    ((RecordBatchData)d).getSv2().clear();
                    ++recordBatchId;
                }
                break;
            }
            default: {
                throw new UnsupportedOperationException();
            }
        }
        ArrayListMultimap vectors = ArrayListMultimap.create();
        for (RecordBatchData rbd : this.batches.values()) {
            for (ValueVector v : rbd.getVectors()) {
                vectors.put(v.getField(), v);
            }
        }
        for (MaterializedField f : schema) {
            List v = vectors.get(f);
            outputContainer.addHyperList(v, false);
        }
        outputContainer.buildSchema(BatchSchema.SelectionVectorMode.FOUR_BYTE);
    }

    public SelectionVector4 getSv4() {
        return this.sv4;
    }

    public void clear() {
        for (RecordBatchData d : this.batches.values()) {
            d.container.clear();
        }
        if (this.sv4 != null) {
            this.sv4.clear();
        }
    }

    @Override
    public void close() {
        this.reservation.close();
    }

    public List<VectorContainer> getHeldRecordBatches() {
        ArrayList<VectorContainer> containerList = Lists.newArrayList();
        for (BatchSchema bs : this.batches.keySet()) {
            for (RecordBatchData bd : this.batches.get((Object)bs)) {
                VectorContainer c = bd.getContainer();
                c.setRecordCount(bd.getRecordCount());
                containerList.add(c);
            }
        }
        this.batches.clear();
        return containerList;
    }

    public static long memoryNeeded(int recordCount) {
        return BaseAllocator.nextPowerOfTwo(recordCount * 4);
    }
}

