/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.physical.impl.statistics;

import java.util.HashMap;
import java.util.Map;
import org.apache.drill.common.types.TypeProtos;
import org.apache.drill.exec.physical.impl.statistics.AbstractMergedStatistic;
import org.apache.drill.exec.vector.ValueVector;
import org.apache.drill.exec.vector.VarCharVector;
import org.apache.drill.exec.vector.complex.MapVector;
import org.apache.drill.metastore.statistics.Statistic;

public class ColTypeMergedStatistic
extends AbstractMergedStatistic {
    private Map<String, byte[]> typeHolder = new HashMap<String, byte[]>();

    public ColTypeMergedStatistic() {
        this.state = Statistic.State.INIT;
    }

    @Override
    public void initialize(String inputName, double samplePercent) {
        super.initialize("majortype", inputName, samplePercent);
        this.state = Statistic.State.MERGE;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getInput() {
        return this.inputName;
    }

    @Override
    public void merge(MapVector input) {
        assert (input.getField().getType().getMinorType() == TypeProtos.MinorType.MAP);
        for (ValueVector vv : input) {
            String colName = vv.getField().getName();
            if (this.typeHolder.get(colName) != null) continue;
            VarCharVector iv = (VarCharVector)vv;
            VarCharVector.Accessor accessor = iv.getAccessor();
            this.typeHolder.put(colName, accessor.get(0));
        }
    }

    public byte[] getStat(String colName) {
        if (this.state != Statistic.State.COMPLETE) {
            throw new IllegalStateException(String.format("Statistic `%s` has not completed merging statistics", this.name));
        }
        return this.typeHolder.get(colName);
    }

    @Override
    public void setOutput(MapVector output) {
        assert (output.getField().getType().getMinorType() == TypeProtos.MinorType.MAP);
        for (ValueVector outMapCol : output) {
            String colName = outMapCol.getField().getName();
            VarCharVector vv = (VarCharVector)outMapCol;
            vv.allocateNewSafe();
            vv.getMutator().setSafe(0, this.typeHolder.get(colName));
        }
        this.state = Statistic.State.COMPLETE;
    }
}

