/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.physical.impl.statistics;

import com.clearspring.analytics.stream.cardinality.HyperLogLog;
import java.io.ByteArrayInputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.apache.drill.common.types.TypeProtos;
import org.apache.drill.exec.physical.impl.statistics.AbstractMergedStatistic;
import org.apache.drill.exec.server.options.OptionManager;
import org.apache.drill.exec.vector.NullableVarBinaryVector;
import org.apache.drill.exec.vector.ValueVector;
import org.apache.drill.exec.vector.complex.MapVector;
import org.apache.drill.metastore.statistics.Statistic;

public class HLLMergedStatistic
extends AbstractMergedStatistic {
    private Map<String, HyperLogLog> hllHolder = new HashMap<String, HyperLogLog>();
    private long accuracy;

    public HLLMergedStatistic() {
        this.state = Statistic.State.INIT;
    }

    @Override
    public void initialize(String inputName, double samplePercent) {
        super.initialize("hll_merge", inputName, samplePercent);
        this.state = Statistic.State.CONFIG;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getInput() {
        return this.inputName;
    }

    @Override
    public void merge(MapVector input) {
        assert (input.getField().getType().getMinorType() == TypeProtos.MinorType.MAP);
        for (ValueVector vv : input) {
            String colName = vv.getField().getName();
            HyperLogLog colHLLHolder = null;
            if (this.hllHolder.get(colName) != null) {
                colHLLHolder = this.hllHolder.get(colName);
            }
            NullableVarBinaryVector hllVector = (NullableVarBinaryVector)vv;
            NullableVarBinaryVector.Accessor accessor = hllVector.getAccessor();
            try {
                if (accessor.isNull(0)) continue;
                ByteArrayInputStream bais = new ByteArrayInputStream(accessor.get(0), 0, vv.getBufferSize());
                HyperLogLog other = HyperLogLog.Builder.build((DataInput)new DataInputStream(bais));
                if (colHLLHolder != null) {
                    colHLLHolder.addAll(other);
                    this.hllHolder.put(colName, colHLLHolder);
                    continue;
                }
                this.hllHolder.put(colName, other);
            }
            catch (Exception exception) {}
        }
    }

    public HyperLogLog getStat(String colName) {
        if (this.state != Statistic.State.COMPLETE) {
            throw new IllegalStateException(String.format("Statistic `%s` has not completed merging statistics", this.name));
        }
        return this.hllHolder.get(colName);
    }

    @Override
    public void setOutput(MapVector output) {
        assert (output.getField().getType().getMinorType() == TypeProtos.MinorType.MAP);
        assert (this.state == Statistic.State.MERGE);
        for (ValueVector outMapCol : output) {
            String colName = outMapCol.getField().getName();
            HyperLogLog colHLLHolder = this.hllHolder.get(colName);
            NullableVarBinaryVector vv = (NullableVarBinaryVector)outMapCol;
            vv.allocateNewSafe();
            try {
                if (colHLLHolder != null) {
                    vv.getMutator().setSafe(0, colHLLHolder.getBytes(), 0, colHLLHolder.getBytes().length);
                    continue;
                }
                vv.getMutator().setNull(0);
            }
            catch (IOException iOException) {}
        }
        this.state = Statistic.State.COMPLETE;
    }

    public void configure(OptionManager optionsManager) {
        assert (this.state == Statistic.State.CONFIG);
        this.accuracy = optionsManager.getLong("exec.statistics.ndv_accuracy");
        this.state = Statistic.State.MERGE;
    }
}

