/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.physical.impl.statistics;

import java.util.HashMap;
import org.apache.drill.exec.physical.impl.statistics.AvgWidthMergedStatistic;
import org.apache.drill.exec.physical.impl.statistics.CntDupsMergedStatistic;
import org.apache.drill.exec.physical.impl.statistics.ColTypeMergedStatistic;
import org.apache.drill.exec.physical.impl.statistics.ColumnMergedStatistic;
import org.apache.drill.exec.physical.impl.statistics.HLLMergedStatistic;
import org.apache.drill.exec.physical.impl.statistics.MergedStatistic;
import org.apache.drill.exec.physical.impl.statistics.NDVMergedStatistic;
import org.apache.drill.exec.physical.impl.statistics.NNRowCountMergedStatistic;
import org.apache.drill.exec.physical.impl.statistics.RowCountMergedStatistic;
import org.apache.drill.exec.physical.impl.statistics.TDigestMergedStatistic;

public class MergedStatisticFactory {
    private HashMap<String, Class<? extends MergedStatistic>> statsClasses = new HashMap();
    private static MergedStatisticFactory instance = new MergedStatisticFactory();

    private MergedStatisticFactory() {
        this.statsClasses.put("column", ColumnMergedStatistic.class);
        this.statsClasses.put("majortype", ColTypeMergedStatistic.class);
        this.statsClasses.put("rowcount", RowCountMergedStatistic.class);
        this.statsClasses.put("nonnullrowcount", NNRowCountMergedStatistic.class);
        this.statsClasses.put("avg_width", AvgWidthMergedStatistic.class);
        this.statsClasses.put("hll_merge", HLLMergedStatistic.class);
        this.statsClasses.put("approx_count_distinct", NDVMergedStatistic.class);
        this.statsClasses.put("sum", CntDupsMergedStatistic.class);
        this.statsClasses.put("tdigest_merge", TDigestMergedStatistic.class);
    }

    private MergedStatistic newMergedStatistic(String outputStatName) throws InstantiationException, IllegalAccessException {
        MergedStatistic stat = this.statsClasses.get(outputStatName).newInstance();
        return stat;
    }

    public static MergedStatistic getMergedStatistic(String outputStatName, String inputStatName, double samplePercent) {
        try {
            MergedStatistic statistic = instance.newMergedStatistic(outputStatName);
            if (statistic == null) {
                throw new IllegalArgumentException("No implementation found for " + outputStatName);
            }
            statistic.initialize(inputStatName, samplePercent);
            return statistic;
        }
        catch (InstantiationException ex) {
            throw new IllegalArgumentException("Cannot instantiate class for " + outputStatName);
        }
        catch (IllegalAccessException ex) {
            throw new IllegalArgumentException("Cannot access class for " + outputStatName);
        }
    }
}

