/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.physical.impl.statistics;

import com.clearspring.analytics.stream.cardinality.CardinalityMergeException;
import com.clearspring.analytics.stream.cardinality.HyperLogLog;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.json.JsonMapper;
import com.fasterxml.jackson.databind.module.SimpleModule;
import java.io.ByteArrayInputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.drill.common.types.TypeProtos;
import org.apache.drill.common.util.JacksonUtils;
import org.apache.drill.exec.physical.impl.statistics.AbstractMergedStatistic;
import org.apache.drill.exec.physical.impl.statistics.CntDupsMergedStatistic;
import org.apache.drill.exec.physical.impl.statistics.ColTypeMergedStatistic;
import org.apache.drill.exec.physical.impl.statistics.MergedStatistic;
import org.apache.drill.exec.physical.impl.statistics.NNRowCountMergedStatistic;
import org.apache.drill.exec.physical.impl.statistics.RowCountMergedStatistic;
import org.apache.drill.exec.record.MajorTypeSerDe;
import org.apache.drill.exec.server.options.OptionManager;
import org.apache.drill.exec.vector.NullableBigIntVector;
import org.apache.drill.exec.vector.NullableVarBinaryVector;
import org.apache.drill.exec.vector.ValueVector;
import org.apache.drill.exec.vector.complex.MapVector;
import org.apache.drill.metastore.statistics.Statistic;

public class NDVMergedStatistic
extends AbstractMergedStatistic {
    private Map<String, HyperLogLog> hllHolder = new HashMap<String, HyperLogLog>();
    ColTypeMergedStatistic types = null;
    NNRowCountMergedStatistic nonNullStatCounts = null;
    RowCountMergedStatistic statCounts = null;
    CntDupsMergedStatistic sumDups = null;

    public NDVMergedStatistic() {
        this.state = Statistic.State.INIT;
    }

    @Override
    public void initialize(String inputName, double samplePercent) {
        super.initialize("approx_count_distinct", inputName, samplePercent);
        this.state = Statistic.State.CONFIG;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getInput() {
        return this.inputName;
    }

    @Override
    public void merge(MapVector input) {
        assert (input.getField().getType().getMinorType() == TypeProtos.MinorType.MAP);
        assert (this.state == Statistic.State.MERGE);
        for (ValueVector vv : input) {
            String colName = vv.getField().getName();
            HyperLogLog colHLLHolder = null;
            if (this.hllHolder.get(colName) != null) {
                colHLLHolder = this.hllHolder.get(colName);
            }
            NullableVarBinaryVector hllVector = (NullableVarBinaryVector)vv;
            NullableVarBinaryVector.Accessor accessor = hllVector.getAccessor();
            try {
                if (accessor.isNull(0)) continue;
                ByteArrayInputStream bais = new ByteArrayInputStream(accessor.get(0), 0, vv.getBufferSize());
                HyperLogLog other = HyperLogLog.Builder.build((DataInput)new DataInputStream(bais));
                if (colHLLHolder != null) {
                    colHLLHolder.addAll(other);
                    this.hllHolder.put(colName, colHLLHolder);
                    continue;
                }
                this.hllHolder.put(colName, other);
            }
            catch (CardinalityMergeException ex) {
                throw new IllegalStateException("Failed to merge the NDV statistics");
            }
            catch (Exception ex) {
                throw new IllegalStateException(ex);
            }
        }
    }

    public long getStat(String colName) {
        if (this.state != Statistic.State.COMPLETE) {
            throw new IllegalStateException(String.format("Statistic `%s` has not completed merging statistics", this.name));
        }
        return this.hllHolder.get(colName).cardinality();
    }

    @Override
    public void setOutput(MapVector output) {
        assert (output.getField().getType().getMinorType() == TypeProtos.MinorType.MAP);
        assert (this.state == Statistic.State.MERGE);
        for (ValueVector outMapCol : output) {
            String colName = outMapCol.getField().getName();
            HyperLogLog colHLLHolder = this.hllHolder.get(colName);
            NullableBigIntVector vv = (NullableBigIntVector)outMapCol;
            vv.allocateNewSafe();
            if (colHLLHolder != null) {
                double sampleRows = this.samplePercent / 100.0 * (double)this.getRowCount(colName);
                double sampleSingletons = sampleRows - this.sumDups.getStat(colName);
                double estNdv = sampleRows * (double)colHLLHolder.cardinality() / (sampleRows - sampleSingletons + sampleSingletons * this.samplePercent / 100.0);
                estNdv = Math.min(estNdv, 100.0 * sampleRows / this.samplePercent);
                vv.getMutator().setSafe(0, 1, (long)estNdv);
                continue;
            }
            vv.getMutator().setNull(0);
        }
        this.state = Statistic.State.COMPLETE;
    }

    public void configure(NDVConfiguration ndvConfig) {
        assert (this.state == Statistic.State.CONFIG);
        for (MergedStatistic statistic : ndvConfig.dependencies) {
            if (statistic.getName().equals("majortype")) {
                this.types = (ColTypeMergedStatistic)statistic;
                continue;
            }
            if (statistic.getName().equals("rowcount")) {
                this.statCounts = (RowCountMergedStatistic)statistic;
                continue;
            }
            if (statistic.getName().equals("nonnullrowcount")) {
                this.nonNullStatCounts = (NNRowCountMergedStatistic)statistic;
                continue;
            }
            if (!statistic.getName().equals("sum")) continue;
            this.sumDups = (CntDupsMergedStatistic)statistic;
        }
        assert (this.types != null && this.statCounts != null && this.nonNullStatCounts != null && this.sumDups != null);
        this.state = Statistic.State.MERGE;
    }

    private long getRowCount(String colName) {
        byte[] typeAsBytes = this.types.getStat(colName);
        int type = -1;
        SimpleModule deModule = new SimpleModule("StatisticsSerDeModule").addDeserializer(TypeProtos.MajorType.class, (JsonDeserializer)new MajorTypeSerDe.De());
        ObjectMapper mapper = ((JsonMapper.Builder)JacksonUtils.createJsonMapperBuilder().addModule((Module)deModule)).build();
        try {
            type = ((TypeProtos.MajorType)mapper.readValue(typeAsBytes, TypeProtos.MajorType.class)).getMinorType().getNumber();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (type == TypeProtos.MinorType.VAR16CHAR.getNumber() || type == TypeProtos.MinorType.VARCHAR.getNumber() || type == TypeProtos.MinorType.VARBINARY.getNumber()) {
            return this.nonNullStatCounts.getStat(colName);
        }
        return this.statCounts.getStat(colName);
    }

    public static class NDVConfiguration {
        private final OptionManager optionManager;
        private final List<MergedStatistic> dependencies;

        public NDVConfiguration(OptionManager optionsManager, List<MergedStatistic> statistics) {
            this.optionManager = optionsManager;
            this.dependencies = statistics;
        }
    }
}

