/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.physical.impl.statistics;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.sun.codemodel.JExpr;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.drill.common.exceptions.UserException;
import org.apache.drill.common.expression.FunctionCallFactory;
import org.apache.drill.common.expression.LogicalExpression;
import org.apache.drill.common.expression.SchemaPath;
import org.apache.drill.common.expression.ValueExpressions;
import org.apache.drill.exec.exception.OutOfMemoryException;
import org.apache.drill.exec.exception.SchemaChangeException;
import org.apache.drill.exec.expr.ClassGenerator;
import org.apache.drill.exec.expr.CodeGenerator;
import org.apache.drill.exec.expr.TypeHelper;
import org.apache.drill.exec.expr.ValueVectorWriteExpression;
import org.apache.drill.exec.ops.FragmentContext;
import org.apache.drill.exec.physical.base.PhysicalOperatorUtil;
import org.apache.drill.exec.physical.config.StatisticsAggregate;
import org.apache.drill.exec.physical.impl.aggregate.StreamingAggBatch;
import org.apache.drill.exec.physical.impl.aggregate.StreamingAggTemplate;
import org.apache.drill.exec.physical.impl.aggregate.StreamingAggregator;
import org.apache.drill.exec.planner.common.DrillStatsTable;
import org.apache.drill.exec.record.BatchSchema;
import org.apache.drill.exec.record.MaterializedField;
import org.apache.drill.exec.record.RecordBatch;
import org.apache.drill.exec.record.TypedFieldId;
import org.apache.drill.exec.server.options.OptionManager;
import org.apache.drill.exec.store.ColumnExplorer;
import org.apache.drill.exec.vector.ValueVector;
import org.apache.drill.exec.vector.complex.FieldIdUtil;
import org.apache.drill.exec.vector.complex.MapVector;
import org.apache.drill.shaded.guava.com.google.common.collect.Lists;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StatisticsAggBatch
extends StreamingAggBatch {
    private static final Logger logger = LoggerFactory.getLogger(StatisticsAggBatch.class);
    private final List<String> functions;
    private final Map<String, ColumnExplorer.ImplicitFileColumns> implicitFileColumnsMap;

    public StatisticsAggBatch(StatisticsAggregate popConfig, RecordBatch incoming, FragmentContext context) throws OutOfMemoryException {
        super(popConfig, incoming, context);
        this.functions = popConfig.getFunctions();
        this.implicitFileColumnsMap = ColumnExplorer.initImplicitFileColumns(context.getOptions());
    }

    private boolean isImplicitFileOrPartitionColumn(MaterializedField mf, OptionManager optionManager) {
        return this.implicitFileColumnsMap.get(SchemaPath.getSimplePath(mf.getName()).toString()) != null || ColumnExplorer.isPartitionColumn(optionManager, SchemaPath.getSimplePath(mf.getName()));
    }

    private TypedFieldId createVVFieldId(LogicalExpression mle, String name, MapVector parent) {
        Class<? extends ValueVector> vvc = TypeHelper.getValueVectorClass(mle.getMajorType().getMinorType(), mle.getMajorType().getMode());
        ValueVector vv = parent.addOrGet(name, mle.getMajorType(), vvc);
        TypedFieldId pfid = this.container.getValueVectorId(SchemaPath.getSimplePath(parent.getField().getName()));
        assert (pfid.getFieldIds().length == 1);
        TypedFieldId.Builder builder = TypedFieldId.newBuilder();
        builder.addId(pfid.getFieldIds()[0]);
        TypedFieldId id = FieldIdUtil.getFieldIdIfMatches(parent, builder, true, SchemaPath.getSimplePath(vv.getField().getName()).getRootSegment());
        return id;
    }

    private void createNestedKeyColumn(MapVector parent, String name, LogicalExpression expr, List<LogicalExpression> keyExprs, List<TypedFieldId> keyOutputIds) {
        LogicalExpression mle = PhysicalOperatorUtil.materializeExpression(expr, this.incoming, this.context);
        TypedFieldId id = this.createVVFieldId(mle, name, parent);
        keyExprs.add(mle);
        keyOutputIds.add(id);
    }

    private void addMapVector(String name, MapVector parent, LogicalExpression expr, List<LogicalExpression> valueExprs) {
        LogicalExpression mle = PhysicalOperatorUtil.materializeExpression(expr, this.incoming, this.context);
        TypedFieldId id = this.createVVFieldId(mle, name, parent);
        valueExprs.add(new ValueVectorWriteExpression(id, mle, true));
    }

    private StreamingAggregator codegenAggregator(List<LogicalExpression> keyExprs, List<LogicalExpression> valueExprs, List<TypedFieldId> keyOutputIds) {
        ClassGenerator<StreamingAggregator> cg = CodeGenerator.getRoot(StreamingAggTemplate.TEMPLATE_DEFINITION, this.context.getOptions());
        cg.getCodeGenerator().plainJavaCapable(true);
        LogicalExpression[] keyExprsArray = new LogicalExpression[keyExprs.size()];
        LogicalExpression[] valueExprsArray = new LogicalExpression[valueExprs.size()];
        TypedFieldId[] keyOutputIdsArray = new TypedFieldId[keyOutputIds.size()];
        keyExprs.toArray(keyExprsArray);
        valueExprs.toArray(valueExprsArray);
        keyOutputIds.toArray(keyOutputIdsArray);
        this.setupIsSame(cg, keyExprsArray);
        this.setupIsSameApart(cg, keyExprsArray);
        this.addRecordValues(cg, valueExprsArray);
        this.outputRecordKeys(cg, keyOutputIdsArray, keyExprsArray);
        this.outputRecordKeysPrev(cg, keyOutputIdsArray, keyExprsArray);
        cg.getBlock("resetValues")._return(JExpr.TRUE);
        this.getIndex(cg);
        this.container.buildSchema(BatchSchema.SelectionVectorMode.NONE);
        StreamingAggregator agg = this.context.getImplementationClass(cg);
        try {
            agg.setup(this.oContext, this.incoming, this, 65536);
        }
        catch (SchemaChangeException e) {
            throw this.schemaChangeException(e, logger);
        }
        return agg;
    }

    @Override
    protected StreamingAggregator createAggregatorInternal() {
        ArrayList<LogicalExpression> keyExprs = Lists.newArrayList();
        ArrayList<LogicalExpression> valueExprs = Lists.newArrayList();
        ArrayList<TypedFieldId> keyOutputIds = Lists.newArrayList();
        String[] colMeta = new String[]{"column", "majortype"};
        this.container.clear();
        for (String col : colMeta) {
            MapVector parent = new MapVector(col, this.oContext.getAllocator(), null);
            this.container.add(parent);
            for (MaterializedField mf : this.incoming.getSchema()) {
                LogicalExpression expr;
                if (col.equals(colMeta[0])) {
                    expr = ValueExpressions.getChar(SchemaPath.getSimplePath(mf.getName()).toString(), 0);
                } else {
                    try {
                        expr = ValueExpressions.getChar(DrillStatsTable.getMapper().writeValueAsString((Object)mf.getType()), 0);
                    }
                    catch (JsonProcessingException e) {
                        throw UserException.dataWriteError(e).addContext("Failed to write statistics to JSON").build();
                    }
                }
                if (this.isImplicitFileOrPartitionColumn(mf, this.incoming.getContext().getOptions())) continue;
                this.createNestedKeyColumn(parent, SchemaPath.getSimplePath(mf.getName()).toString(), expr, keyExprs, keyOutputIds);
            }
        }
        for (String func : this.functions) {
            MapVector parent = new MapVector(func, this.oContext.getAllocator(), null);
            this.container.add(parent);
            for (MaterializedField mf : this.incoming.getSchema()) {
                if (!this.isColMinorTypeValid(mf) || this.isImplicitFileOrPartitionColumn(mf, this.incoming.getContext().getOptions())) continue;
                ArrayList<LogicalExpression> args = Lists.newArrayList();
                args.add(SchemaPath.getSimplePath(mf.getName()));
                LogicalExpression call = FunctionCallFactory.createExpression(func, args);
                this.addMapVector(SchemaPath.getSimplePath(mf.getName()).toString(), parent, call, valueExprs);
            }
        }
        return this.codegenAggregator(keyExprs, valueExprs, keyOutputIds);
    }

    private boolean isColMinorTypeValid(MaterializedField mf) throws UnsupportedOperationException {
        switch (mf.getType().getMinorType()) {
            case GENERIC_OBJECT: 
            case LATE: 
            case LIST: 
            case MAP: 
            case DICT: 
            case UNION: {
                return false;
            }
        }
        return true;
    }
}

