/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.physical.impl.statistics;

import com.tdunning.math.stats.MergingDigest;
import com.tdunning.math.stats.TDigest;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.Map;
import org.apache.drill.common.types.TypeProtos;
import org.apache.drill.exec.physical.impl.statistics.AbstractMergedStatistic;
import org.apache.drill.exec.server.options.OptionManager;
import org.apache.drill.exec.vector.NullableVarBinaryVector;
import org.apache.drill.exec.vector.ValueVector;
import org.apache.drill.exec.vector.complex.MapVector;
import org.apache.drill.metastore.statistics.Statistic;

public class TDigestMergedStatistic
extends AbstractMergedStatistic {
    private Map<String, MergingDigest> tdigestHolder = new HashMap<String, MergingDigest>();
    private int compression;

    public TDigestMergedStatistic() {
        this.state = Statistic.State.INIT;
    }

    @Override
    public void initialize(String inputName, double samplePercent) {
        super.initialize("tdigest_merge", inputName, samplePercent);
        this.state = Statistic.State.CONFIG;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getInput() {
        return this.inputName;
    }

    @Override
    public void merge(MapVector input) {
        assert (input.getField().getType().getMinorType() == TypeProtos.MinorType.MAP);
        for (ValueVector vv : input) {
            NullableVarBinaryVector tdigestVector;
            NullableVarBinaryVector.Accessor accessor;
            String colName = vv.getField().getName();
            MergingDigest colTdigestHolder = null;
            if (this.tdigestHolder.get(colName) != null) {
                colTdigestHolder = this.tdigestHolder.get(colName);
            }
            if ((accessor = (tdigestVector = (NullableVarBinaryVector)vv).getAccessor()).isNull(0)) continue;
            MergingDigest other = MergingDigest.fromBytes((ByteBuffer)ByteBuffer.wrap(accessor.get(0)));
            if (colTdigestHolder != null) {
                colTdigestHolder.add((TDigest)other);
                this.tdigestHolder.put(colName, colTdigestHolder);
                continue;
            }
            this.tdigestHolder.put(colName, other);
        }
    }

    public MergingDigest getStat(String colName) {
        if (this.state != Statistic.State.COMPLETE) {
            throw new IllegalStateException(String.format("Statistic `%s` has not completed merging statistics", this.name));
        }
        return this.tdigestHolder.get(colName);
    }

    @Override
    public void setOutput(MapVector output) {
        assert (output.getField().getType().getMinorType() == TypeProtos.MinorType.MAP);
        assert (this.state == Statistic.State.MERGE);
        for (ValueVector outMapCol : output) {
            String colName = outMapCol.getField().getName();
            MergingDigest colTdigestHolder = this.tdigestHolder.get(colName);
            NullableVarBinaryVector vv = (NullableVarBinaryVector)outMapCol;
            vv.allocateNewSafe();
            try {
                if (colTdigestHolder != null) {
                    int size = colTdigestHolder.smallByteSize();
                    ByteBuffer byteBuf = ByteBuffer.allocate(size);
                    colTdigestHolder.asSmallBytes(byteBuf);
                    vv.getMutator().setSafe(0, byteBuf.array(), 0, byteBuf.array().length);
                    continue;
                }
                vv.getMutator().setNull(0);
            }
            catch (Exception exception) {}
        }
        this.state = Statistic.State.COMPLETE;
    }

    public void configure(OptionManager optionsManager) {
        assert (this.state == Statistic.State.CONFIG);
        this.compression = (int)optionsManager.getLong("exec.statistics.tdigest_compression");
        this.state = Statistic.State.MERGE;
    }
}

