/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.physical.impl.svremover;

import org.apache.drill.common.types.TypeProtos;
import org.apache.drill.common.types.Types;
import org.apache.drill.exec.physical.impl.svremover.Copier;
import org.apache.drill.exec.record.VectorAccessible;
import org.apache.drill.exec.record.VectorContainer;
import org.apache.drill.exec.record.VectorWrapper;
import org.apache.drill.exec.vector.AllocationHelper;
import org.apache.drill.exec.vector.ValueVector;

public abstract class AbstractCopier
implements Copier {
    protected ValueVector[] vvOut;
    protected VectorContainer outgoing;

    @Override
    public void setup(VectorAccessible incoming, VectorContainer outgoing) {
        this.outgoing = outgoing;
        int count = outgoing.getNumberOfColumns();
        this.vvOut = new ValueVector[count];
        for (int index = 0; index < count; ++index) {
            this.vvOut[index] = outgoing.getValueVector(index).getValueVector();
        }
    }

    @Override
    public int copyRecords(int index, int recordCount) {
        AbstractCopier.allocateOutgoing(this.outgoing, recordCount);
        return this.insertRecords(0, index, recordCount);
    }

    @Override
    public int appendRecord(int index) {
        int outgoingPosition = this.outgoing.getRecordCount();
        this.copyEntryIndirect(index, outgoingPosition);
        this.updateCounts(++outgoingPosition);
        return outgoingPosition;
    }

    @Override
    public int appendRecords(int index, int recordCount) {
        return this.insertRecords(this.outgoing.getRecordCount(), index, recordCount);
    }

    private int insertRecords(int outgoingPosition, int index, int recordCount) {
        int endIndex = index + recordCount;
        int svIndex = index;
        while (svIndex < endIndex) {
            this.copyEntryIndirect(svIndex, outgoingPosition);
            ++svIndex;
            ++outgoingPosition;
        }
        this.updateCounts(outgoingPosition);
        return outgoingPosition;
    }

    protected void updateCounts(int numRecords) {
        this.outgoing.setValueCount(numRecords);
    }

    public abstract void copyEntryIndirect(int var1, int var2);

    public abstract void copyEntry(int var1, int var2);

    public static void allocateOutgoing(VectorContainer outgoing, int recordCount) {
        for (VectorWrapper<?> out : outgoing) {
            TypeProtos.MajorType type = out.getField().getType();
            if (!Types.isFixedWidthType(type) || Types.isRepeated(type)) {
                out.getValueVector().allocateNew();
                continue;
            }
            AllocationHelper.allocate(out.getValueVector(), recordCount, 1);
        }
    }
}

