/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.physical.impl.svremover;

import org.apache.drill.exec.physical.impl.svremover.AbstractCopier;
import org.apache.drill.exec.physical.impl.svremover.Copier;
import org.apache.drill.exec.record.VectorAccessible;
import org.apache.drill.exec.record.VectorContainer;
import org.apache.drill.exec.record.VectorWrapper;
import org.apache.drill.exec.vector.ValueVector;

public class GenericCopier
implements Copier {
    private ValueVector[] vvOut;
    private ValueVector[] vvIn;
    private VectorContainer outgoing;

    @Override
    public void setup(VectorAccessible incoming, VectorContainer outgoing) {
        this.outgoing = outgoing;
        int count = outgoing.getNumberOfColumns();
        this.vvIn = new ValueVector[count];
        this.vvOut = new ValueVector[count];
        int index = 0;
        for (VectorWrapper vectorWrapper : incoming) {
            this.vvIn[index] = vectorWrapper.getValueVector();
            ++index;
        }
        for (index = 0; index < count; ++index) {
            this.vvOut[index] = outgoing.getValueVector(index).getValueVector();
        }
    }

    @Override
    public int copyRecords(int index, int recordCount) {
        AbstractCopier.allocateOutgoing(this.outgoing, recordCount);
        return this.insertRecords(0, index, recordCount);
    }

    @Override
    public int appendRecord(int index) {
        int outgoingPosition = this.outgoing.getRecordCount();
        for (int vectorIndex = 0; vectorIndex < this.vvIn.length; ++vectorIndex) {
            this.vvOut[vectorIndex].copyEntry(outgoingPosition, this.vvIn[vectorIndex], index);
        }
        this.updateCounts(++outgoingPosition);
        return outgoingPosition;
    }

    @Override
    public int appendRecords(int index, int recordCount) {
        return this.insertRecords(this.outgoing.getRecordCount(), index, recordCount);
    }

    private int insertRecords(int outgoingPosition, int startIndex, int recordCount) {
        int endIndex = startIndex + recordCount;
        int index = startIndex;
        while (index < endIndex) {
            for (int vectorIndex = 0; vectorIndex < this.vvIn.length; ++vectorIndex) {
                this.vvOut[vectorIndex].copyEntry(outgoingPosition, this.vvIn[vectorIndex], index);
            }
            ++index;
            ++outgoingPosition;
        }
        this.updateCounts(outgoingPosition);
        return outgoingPosition;
    }

    private void updateCounts(int numRecords) {
        this.outgoing.setRecordCount(numRecords);
        for (int vectorIndex = 0; vectorIndex < this.vvOut.length; ++vectorIndex) {
            this.vvOut[vectorIndex].getMutator().setValueCount(numRecords);
        }
    }
}

