/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.physical.impl.svremover;

import org.apache.drill.exec.physical.impl.svremover.Copier;
import org.apache.drill.exec.physical.impl.svremover.GenericCopier;
import org.apache.drill.exec.physical.impl.svremover.GenericSV2Copier;
import org.apache.drill.exec.physical.impl.svremover.GenericSV4Copier;
import org.apache.drill.exec.physical.impl.svremover.StraightCopier;
import org.apache.drill.exec.record.RecordBatch;
import org.apache.drill.exec.record.VectorContainer;
import org.apache.drill.exec.vector.SchemaChangeCallBack;

public class GenericCopierFactory {
    public static Copier createAndSetupCopier(RecordBatch incoming, VectorContainer outputContainer, SchemaChangeCallBack callBack) {
        Copier copier;
        switch (incoming.getSchema().getSelectionVectorMode()) {
            case NONE: {
                copier = new StraightCopier(incoming, outputContainer, callBack);
                break;
            }
            case TWO_BYTE: {
                copier = new GenericSV2Copier(incoming, outputContainer, callBack);
                break;
            }
            case FOUR_BYTE: {
                copier = new GenericSV4Copier(incoming, outputContainer, callBack);
                break;
            }
            default: {
                throw new UnsupportedOperationException();
            }
        }
        copier.setup(incoming, outputContainer);
        return copier;
    }

    public static Copier createAndSetupNonSVGenericCopier(RecordBatch incoming, VectorContainer outputContainer) {
        GenericCopier copier = new GenericCopier();
        copier.setup(incoming, outputContainer);
        return copier;
    }
}

