/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.physical.impl.svremover;

import org.apache.drill.exec.exception.OutOfMemoryException;
import org.apache.drill.exec.ops.FragmentContext;
import org.apache.drill.exec.physical.config.SelectionVectorRemover;
import org.apache.drill.exec.physical.impl.svremover.Copier;
import org.apache.drill.exec.physical.impl.svremover.GenericCopierFactory;
import org.apache.drill.exec.record.AbstractSingleRecordBatch;
import org.apache.drill.exec.record.BatchSchema;
import org.apache.drill.exec.record.RecordBatch;
import org.apache.drill.exec.record.WritableBatch;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RemovingRecordBatch
extends AbstractSingleRecordBatch<SelectionVectorRemover> {
    private static final Logger logger = LoggerFactory.getLogger(RemovingRecordBatch.class);
    private Copier copier;

    public RemovingRecordBatch(SelectionVectorRemover popConfig, FragmentContext context, RecordBatch incoming) throws OutOfMemoryException {
        super(popConfig, context, incoming);
        logger.debug("Created.");
    }

    @Override
    public int getRecordCount() {
        return this.container.getRecordCount();
    }

    @Override
    protected boolean setupNewSchema() {
        this.container.zeroVectors();
        this.copier = GenericCopierFactory.createAndSetupCopier(this.incoming, this.container, this.callBack);
        if (this.container.isSchemaChanged()) {
            this.container.buildSchema(BatchSchema.SelectionVectorMode.NONE);
            return true;
        }
        return false;
    }

    @Override
    protected RecordBatch.IterOutcome doWork() {
        try {
            int rowCount = this.incoming.getRecordCount();
            if (rowCount == 0) {
                this.container.setEmpty();
            } else {
                this.copier.copyRecords(0, rowCount);
            }
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
        finally {
            if (this.incoming.getSchema().getSelectionVectorMode() != BatchSchema.SelectionVectorMode.FOUR_BYTE) {
                this.incoming.getContainer().zeroVectors();
                if (this.incoming.getSchema().getSelectionVectorMode() == BatchSchema.SelectionVectorMode.TWO_BYTE) {
                    this.incoming.getSelectionVector2().clear();
                }
            }
        }
        logger.debug("doWork(): {} records copied out of {}, incoming schema {} ", new Object[]{this.container.getRecordCount(), this.container.getRecordCount(), this.incoming.getSchema()});
        return this.getFinalOutcome(false);
    }

    @Override
    public void close() {
        super.close();
    }

    @Override
    public WritableBatch getWritableBatch() {
        return WritableBatch.get(this);
    }

    @Override
    public void dump() {
        logger.error("RemovingRecordBatch[container={}, state={}, copier={}]", new Object[]{this.container, this.state, this.copier});
    }
}

