/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.physical.impl.svremover;

import java.util.List;
import org.apache.drill.exec.physical.impl.svremover.Copier;
import org.apache.drill.exec.record.RecordBatch;
import org.apache.drill.exec.record.TransferPair;
import org.apache.drill.exec.record.VectorAccessible;
import org.apache.drill.exec.record.VectorContainer;
import org.apache.drill.exec.record.VectorWrapper;
import org.apache.drill.exec.vector.SchemaChangeCallBack;
import org.apache.drill.exec.vector.ValueVector;
import org.apache.drill.shaded.guava.com.google.common.collect.Lists;

public class StraightCopier
implements Copier {
    private List<TransferPair> pairs = Lists.newArrayList();
    private RecordBatch incoming;
    private VectorContainer outputContainer;
    private SchemaChangeCallBack callBack;

    public StraightCopier(RecordBatch incomingBatch, VectorContainer outputContainer, SchemaChangeCallBack callBack) {
        this.incoming = incomingBatch;
        this.outputContainer = outputContainer;
        this.callBack = callBack;
    }

    @Override
    public void setup(VectorAccessible incoming, VectorContainer outgoing) {
        for (VectorWrapper vv : incoming) {
            TransferPair tp = vv.getValueVector().makeTransferPair((ValueVector)this.outputContainer.addOrGet(vv.getField(), this.callBack));
            this.pairs.add(tp);
        }
    }

    @Override
    public int copyRecords(int index, int recordCount) {
        assert (index == 0 && recordCount == this.incoming.getRecordCount()) : "Straight copier cannot split batch";
        for (TransferPair tp : this.pairs) {
            tp.transfer();
        }
        this.outputContainer.setRecordCount(this.incoming.getRecordCount());
        return recordCount;
    }

    @Override
    public int appendRecord(int index) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int appendRecords(int index, int recordCount) {
        throw new UnsupportedOperationException();
    }
}

