/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.physical.impl.trace;

import java.io.IOException;
import java.io.OutputStream;
import org.apache.drill.common.exceptions.ExecutionSetupException;
import org.apache.drill.exec.cache.VectorAccessibleSerializable;
import org.apache.drill.exec.memory.BufferAllocator;
import org.apache.drill.exec.ops.FragmentContext;
import org.apache.drill.exec.physical.config.Trace;
import org.apache.drill.exec.record.AbstractSingleRecordBatch;
import org.apache.drill.exec.record.BatchSchema;
import org.apache.drill.exec.record.RecordBatch;
import org.apache.drill.exec.record.TransferPair;
import org.apache.drill.exec.record.VectorWrapper;
import org.apache.drill.exec.record.WritableBatch;
import org.apache.drill.exec.record.selection.SelectionVector2;
import org.apache.drill.exec.util.Utilities;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TraceRecordBatch
extends AbstractSingleRecordBatch<Trace> {
    static final Logger logger = LoggerFactory.getLogger(TraceRecordBatch.class);
    private SelectionVector2 sv;
    private final BufferAllocator localAllocator;
    final String traceTag;
    private final String logLocation;
    private OutputStream fos;

    public TraceRecordBatch(Trace pop, RecordBatch incoming, FragmentContext context) throws ExecutionSetupException {
        super(pop, context, incoming);
        this.traceTag = pop.traceTag;
        this.logLocation = context.getConfig().getString("drill.exec.trace.directory");
        this.localAllocator = context.getNewChildAllocator("trace", 200, 0L, Long.MAX_VALUE);
        String fileName = this.getFileName();
        try {
            Configuration conf = new Configuration();
            conf.set("fs.defaultFS", context.getConfig().getString("drill.exec.trace.filesystem"));
            FileSystem fs = FileSystem.get((Configuration)conf);
            this.fos = fs.create(new Path(fileName));
        }
        catch (IOException e) {
            throw new ExecutionSetupException("Unable to create file: " + fileName + " check permissions or if directory exists", e);
        }
    }

    @Override
    public int getRecordCount() {
        if (this.sv == null) {
            return this.container.getRecordCount();
        }
        return this.sv.getCount();
    }

    @Override
    protected RecordBatch.IterOutcome doWork() {
        boolean incomingHasSv2 = this.incoming.getSchema().getSelectionVectorMode() == BatchSchema.SelectionVectorMode.TWO_BYTE;
        this.sv = incomingHasSv2 ? this.incoming.getSelectionVector2() : null;
        WritableBatch batch = WritableBatch.getBatchNoHVWrap(this.incoming.getContainer().getRecordCount(), this.incoming, incomingHasSv2);
        VectorAccessibleSerializable wrap = new VectorAccessibleSerializable(batch, this.sv, this.oContext.getAllocator());
        try {
            wrap.writeToStreamAndRetain(this.fos);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        batch.reconstructContainer(this.localAllocator, this.container);
        if (incomingHasSv2) {
            this.sv = wrap.getSv2();
            this.container.setRecordCount(this.sv.getBatchActualRecordCount());
        } else {
            this.container.setRecordCount(batch.getDef().getRecordCount());
        }
        return this.getFinalOutcome(false);
    }

    @Override
    protected boolean setupNewSchema() {
        if (this.incoming.getSchema().getSelectionVectorMode() == BatchSchema.SelectionVectorMode.FOUR_BYTE) {
            throw new UnsupportedOperationException("Trace operator does not work with hyper vectors");
        }
        this.container.clear();
        for (VectorWrapper vv : this.incoming) {
            TransferPair tp = vv.getValueVector().getTransferPair(this.oContext.getAllocator());
            this.container.add(tp.getTo());
        }
        this.container.buildSchema(this.incoming.getSchema().getSelectionVectorMode());
        this.container.setRecordCount(this.incoming.getRecordCount());
        return true;
    }

    @Override
    public SelectionVector2 getSelectionVector2() {
        return this.sv;
    }

    private String getFileName() {
        return Utilities.getFileNameForQueryFragment(this.incoming.getContext(), this.logLocation, this.traceTag);
    }

    @Override
    public void close() {
        if (this.sv != null) {
            this.sv.clear();
        }
        try {
            this.fos.close();
        }
        catch (IOException e) {
            logger.error("Unable to close file descriptors for file: " + this.getFileName());
        }
        super.close();
    }

    @Override
    public void dump() {
        logger.error("TraceRecordBatch[filename={}, logLocation={}, selectionVector={}]", new Object[]{this.getFileName(), this.logLocation, this.sv});
    }
}

