/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.physical.impl.unnest;

import java.util.List;
import org.apache.drill.exec.exception.SchemaChangeException;
import org.apache.drill.exec.ops.FragmentContext;
import org.apache.drill.exec.physical.impl.unnest.Unnest;
import org.apache.drill.exec.record.BatchSchema;
import org.apache.drill.exec.record.RecordBatch;
import org.apache.drill.exec.record.TransferPair;
import org.apache.drill.exec.vector.IntVector;
import org.apache.drill.exec.vector.SchemaChangeCallBack;
import org.apache.drill.exec.vector.ValueVector;
import org.apache.drill.exec.vector.complex.RepeatedValueVector;
import org.apache.drill.shaded.guava.com.google.common.base.Preconditions;
import org.apache.drill.shaded.guava.com.google.common.collect.ImmutableList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UnnestImpl
implements Unnest {
    private static final Logger logger = LoggerFactory.getLogger(UnnestImpl.class);
    private ImmutableList<TransferPair> transfers;
    private BatchSchema.SelectionVectorMode svMode;
    private RepeatedValueVector fieldToUnnest;
    private RepeatedValueVector.RepeatedAccessor accessor;
    private RecordBatch outgoing;
    private IntVector rowIdVector;
    private IntVector.Mutator rowIdVectorMutator;
    private int outputLimit = 65536;
    private int valueIndex;
    private int innerValueIndex = 0;
    private int runningInnerValueIndex;

    @Override
    public void setUnnestField(RepeatedValueVector unnestField) {
        this.fieldToUnnest = unnestField;
        this.accessor = (RepeatedValueVector.RepeatedAccessor)RepeatedValueVector.RepeatedAccessor.class.cast(unnestField.getAccessor());
    }

    @Override
    public RepeatedValueVector getUnnestField() {
        return this.fieldToUnnest;
    }

    @Override
    public void setOutputCount(int outputCount) {
        this.outputLimit = outputCount;
    }

    @Override
    public void setRowIdVector(IntVector v) {
        this.rowIdVector = v;
        this.rowIdVectorMutator = this.rowIdVector.getMutator();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final int unnestRecords(int recordCount) {
        Preconditions.checkArgument(this.svMode == BatchSchema.SelectionVectorMode.NONE, "Unnest does not support selection vector inputs.");
        int initialInnerValueIndex = this.runningInnerValueIndex;
        int nonEmptyArray = 0;
        int outputIndex = 0;
        int valueCount = this.accessor.getValueCount();
        block3: while (this.valueIndex < valueCount) {
            int innerValueCount = this.accessor.getInnerValueCountAt(this.valueIndex);
            logger.trace("Unnest: CurrentRowId: {}, innerValueCount: {}, outputIndex: {},  output limit: {}", new Object[]{this.valueIndex, innerValueCount, outputIndex, this.outputLimit});
            if (innerValueCount > 0) {
                ++nonEmptyArray;
            }
            while (this.innerValueIndex < innerValueCount) {
                if (outputIndex == this.outputLimit) break block3;
                try {
                    this.rowIdVectorMutator.setSafe(outputIndex, this.valueIndex + 1);
                }
                finally {
                    ++outputIndex;
                    ++this.runningInnerValueIndex;
                }
                ++this.innerValueIndex;
            }
            this.innerValueIndex = 0;
            ++this.valueIndex;
        }
        int delta = this.runningInnerValueIndex - initialInnerValueIndex;
        logger.debug("Unnest: Finished processing current batch. [Details: LastProcessedRowIndex: {}, RowsWithNonEmptyArrays: {}, outputIndex: {}, outputLimit: {}, TotalIncomingRecords: {}]", new Object[]{this.valueIndex, nonEmptyArray, delta, this.outputLimit, this.accessor.getValueCount()});
        SchemaChangeCallBack callBack = new SchemaChangeCallBack();
        for (TransferPair t : this.transfers) {
            t.splitAndTransfer(initialInnerValueIndex, delta);
            ValueVector vectorWithData = t.getTo();
            Object outputVector = this.outgoing.getContainer().addOrGet(vectorWithData.getField(), callBack);
            Preconditions.checkState(!callBack.getSchemaChangedAndReset(), "Outgoing container doesn't have expected ValueVector of type %s, present in TransferPair of unnest field", vectorWithData.getClass());
            vectorWithData.makeTransferPair((ValueVector)outputVector).transfer();
        }
        return delta;
    }

    @Override
    public final void setup(FragmentContext context, RecordBatch incoming, RecordBatch outgoing, List<TransferPair> transfers) throws SchemaChangeException {
        this.svMode = incoming.getSchema().getSelectionVectorMode();
        this.outgoing = outgoing;
        if (this.svMode != BatchSchema.SelectionVectorMode.NONE) {
            throw new UnsupportedOperationException("Unnest does not support selection vector inputs.");
        }
        this.transfers = ImmutableList.copyOf(transfers);
    }

    @Override
    public void resetGroupIndex() {
        this.valueIndex = 0;
        this.innerValueIndex = 0;
        this.runningInnerValueIndex = 0;
    }

    @Override
    public void close() {
        if (this.transfers != null) {
            for (TransferPair tp : this.transfers) {
                tp.getTo().close();
            }
            this.transfers = null;
        }
    }

    public String toString() {
        return "UnnestImpl[svMode=" + (Object)((Object)this.svMode) + ", outputLimit=" + this.outputLimit + ", valueIndex=" + this.valueIndex + ", innerValueIndex=" + this.innerValueIndex + ", runningInnerValueIndex=" + this.runningInnerValueIndex + "]";
    }
}

