/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.physical.impl.unorderedreceiver;

import java.util.List;
import org.apache.drill.common.exceptions.ExecutionSetupException;
import org.apache.drill.exec.ops.ExecutorFragmentContext;
import org.apache.drill.exec.physical.config.UnorderedReceiver;
import org.apache.drill.exec.physical.impl.BatchCreator;
import org.apache.drill.exec.physical.impl.unorderedreceiver.UnorderedReceiverBatch;
import org.apache.drill.exec.record.RecordBatch;
import org.apache.drill.exec.work.batch.IncomingBuffers;
import org.apache.drill.exec.work.batch.RawBatchBuffer;

public class UnorderedReceiverCreator
implements BatchCreator<UnorderedReceiver> {
    public UnorderedReceiverBatch getBatch(ExecutorFragmentContext context, UnorderedReceiver receiver, List<RecordBatch> children) throws ExecutionSetupException {
        assert (children == null || children.isEmpty());
        IncomingBuffers bufHolder = context.getBuffers();
        assert (bufHolder != null) : "IncomingBuffers must be defined for any place a receiver is declared.";
        RawBatchBuffer[] buffers = bufHolder.getCollector(receiver.getOppositeMajorFragmentId()).getBuffers();
        assert (buffers.length == 1);
        RawBatchBuffer buffer = buffers[0];
        return new UnorderedReceiverBatch(context, buffer, receiver);
    }
}

