/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.physical.impl.validate;

import org.apache.drill.common.types.TypeProtos;
import org.apache.drill.exec.physical.rowSet.RowSet;
import org.apache.drill.exec.record.RecordBatch;
import org.apache.drill.exec.record.SimpleVectorWrapper;
import org.apache.drill.exec.record.VectorAccessible;
import org.apache.drill.exec.record.VectorContainer;
import org.apache.drill.exec.record.VectorWrapper;
import org.apache.drill.exec.vector.BitVector;
import org.apache.drill.exec.vector.FixedWidthVector;
import org.apache.drill.exec.vector.NullableVar16CharVector;
import org.apache.drill.exec.vector.NullableVarBinaryVector;
import org.apache.drill.exec.vector.NullableVarCharVector;
import org.apache.drill.exec.vector.NullableVarDecimalVector;
import org.apache.drill.exec.vector.NullableVector;
import org.apache.drill.exec.vector.RepeatedBitVector;
import org.apache.drill.exec.vector.UInt1Vector;
import org.apache.drill.exec.vector.UInt4Vector;
import org.apache.drill.exec.vector.ValueVector;
import org.apache.drill.exec.vector.VarBinaryVector;
import org.apache.drill.exec.vector.VarCharVector;
import org.apache.drill.exec.vector.VarDecimalVector;
import org.apache.drill.exec.vector.VariableWidthVector;
import org.apache.drill.exec.vector.ZeroVector;
import org.apache.drill.exec.vector.complex.AbstractRepeatedMapVector;
import org.apache.drill.exec.vector.complex.BaseRepeatedValueVector;
import org.apache.drill.exec.vector.complex.MapVector;
import org.apache.drill.exec.vector.complex.RepeatedListVector;
import org.apache.drill.exec.vector.complex.UnionVector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BatchValidator {
    private static final Logger logger = LoggerFactory.getLogger(BatchValidator.class);
    public static final boolean LOG_TO_STDOUT = true;
    public static final int MAX_ERRORS = 100;
    private final ErrorReporter errorReporter;

    public BatchValidator(ErrorReporter errorReporter) {
        this.errorReporter = errorReporter;
    }

    public static boolean validate(RecordBatch batch) {
        int rowCount;
        ErrorReporter reporter = BatchValidator.errorReporter(batch);
        int valueCount = rowCount = batch.getRecordCount();
        VectorContainer container = batch.getContainer();
        if (!container.hasRecordCount()) {
            reporter.error(String.format("%s: Container record count not set", batch.getClass().getSimpleName()));
        } else {
            int containerRowCount;
            valueCount = containerRowCount = container.getRecordCount();
            switch (batch.getSchema().getSelectionVectorMode()) {
                case FOUR_BYTE: {
                    int sv4Count = batch.getSelectionVector4().getCount();
                    if (sv4Count != rowCount) {
                        reporter.error(String.format("Mismatch between %s record count = %d, SV4 record count = %d", batch.getClass().getSimpleName(), rowCount, sv4Count));
                    }
                    return true;
                }
                case TWO_BYTE: {
                    int svTotalCount;
                    int sv2Count = batch.getSelectionVector2().getCount();
                    if (sv2Count != rowCount) {
                        reporter.error(String.format("Mismatch between %s record count = %d, SV2 record count = %d", batch.getClass().getSimpleName(), rowCount, sv2Count));
                    }
                    if (sv2Count > containerRowCount) {
                        reporter.error(String.format("Mismatch between %s container count = %d, SV2 record count = %d", batch.getClass().getSimpleName(), containerRowCount, sv2Count));
                    }
                    if ((svTotalCount = batch.getSelectionVector2().getBatchActualRecordCount()) == containerRowCount) break;
                    reporter.error(String.format("Mismatch between %s container count = %d, SV2 total count = %d", batch.getClass().getSimpleName(), containerRowCount, svTotalCount));
                    break;
                }
                default: {
                    if (rowCount == containerRowCount) break;
                    reporter.error(String.format("Mismatch between %s record count = %d, container record count = %d", batch.getClass().getSimpleName(), rowCount, containerRowCount));
                }
            }
        }
        new BatchValidator(reporter).validateBatch(batch, valueCount);
        return reporter.errorCount() == 0;
    }

    public static boolean validate(VectorAccessible batch) {
        ErrorReporter reporter = BatchValidator.errorReporter(batch);
        new BatchValidator(reporter).validateBatch(batch, batch.getRecordCount());
        return reporter.errorCount() == 0;
    }

    public static void validate(RowSet rowSet) {
        BatchValidator.validate(rowSet.container());
    }

    private static ErrorReporter errorReporter(VectorAccessible batch) {
        String opName = batch.getClass().getSimpleName();
        return new StdOutReporter(opName);
    }

    public void validateBatch(VectorAccessible batch, int rowCount) {
        for (VectorWrapper w : batch) {
            this.validateWrapper(rowCount, w);
        }
    }

    private void validateWrapper(int rowCount, VectorWrapper<? extends ValueVector> w) {
        if (w instanceof SimpleVectorWrapper) {
            this.validateVector(rowCount, w.getValueVector());
        }
    }

    private void validateVector(int expectedCount, ValueVector vector) {
        this.validateVector(vector.getField().getName(), expectedCount, vector);
    }

    private void validateVector(String name, int expectedCount, ValueVector vector) {
        int valueCount = vector.getAccessor().getValueCount();
        if (valueCount != expectedCount) {
            this.error(name, vector, String.format("Row count = %d, but value count = %d", expectedCount, valueCount));
        }
        this.validateVector(name, vector);
    }

    private void validateVector(String name, ValueVector vector) {
        if (vector instanceof BitVector) {
            this.validateBitVector(name, (BitVector)vector);
        } else if (vector instanceof RepeatedBitVector) {
            this.validateRepeatedBitVector(name, (RepeatedBitVector)vector);
        } else if (vector instanceof NullableVector) {
            this.validateNullableVector(name, (NullableVector)vector);
        } else if (vector instanceof VarCharVector) {
            this.validateVarCharVector(name, (VarCharVector)vector);
        } else if (vector instanceof VarBinaryVector) {
            this.validateVarBinaryVector(name, (VarBinaryVector)vector);
        } else if (!(vector instanceof FixedWidthVector) && !(vector instanceof ZeroVector)) {
            if (vector instanceof BaseRepeatedValueVector) {
                this.validateRepeatedVector(name, (BaseRepeatedValueVector)vector);
            } else if (vector instanceof AbstractRepeatedMapVector) {
                this.validateRepeatedMapVector(name, (AbstractRepeatedMapVector)vector);
            } else if (vector instanceof MapVector) {
                this.validateMapVector(name, (MapVector)vector);
            } else if (vector instanceof RepeatedListVector) {
                this.validateRepeatedListVector(name, (RepeatedListVector)vector);
            } else if (vector instanceof UnionVector) {
                this.validateUnionVector(name, (UnionVector)vector);
            } else if (vector instanceof VarDecimalVector) {
                this.validateVarDecimalVector(name, (VarDecimalVector)vector);
            } else {
                logger.debug("Don't know how to validate vector: {}  of class {}", (Object)name, (Object)vector.getClass().getSimpleName());
            }
        }
    }

    private void validateNullableVector(String name, NullableVector vector) {
        int lastSet;
        int outerCount = vector.getAccessor().getValueCount();
        ValueVector valuesVector = vector.getValuesVector();
        int valueCount = valuesVector.getAccessor().getValueCount();
        if (valueCount != outerCount) {
            this.error(name, vector, String.format("Outer value count = %d, but inner value count = %d", outerCount, valueCount));
        }
        if ((lastSet = this.getLastSet(vector)) != -2 && lastSet != valueCount - 1) {
            this.error(name, vector, String.format("Value count = %d, but last set = %d", valueCount, lastSet));
        }
        this.verifyIsSetVector(vector, (UInt1Vector)vector.getBitsVector());
        this.validateVector(name + "-values", valuesVector);
    }

    private int getLastSet(NullableVector vector) {
        if (vector instanceof NullableVarCharVector) {
            return ((NullableVarCharVector)vector).getMutator().getLastSet();
        }
        if (vector instanceof NullableVarBinaryVector) {
            return ((NullableVarBinaryVector)vector).getMutator().getLastSet();
        }
        if (vector instanceof NullableVarDecimalVector) {
            return ((NullableVarDecimalVector)vector).getMutator().getLastSet();
        }
        if (vector instanceof NullableVar16CharVector) {
            return ((NullableVar16CharVector)vector).getMutator().getLastSet();
        }
        return -2;
    }

    private void validateVarCharVector(String name, VarCharVector vector) {
        int dataLength = vector.getBuffer().writerIndex();
        this.validateVarWidthVector(name, vector, dataLength);
    }

    private void validateVarBinaryVector(String name, VarBinaryVector vector) {
        int dataLength = vector.getBuffer().writerIndex();
        int lastOffset = this.validateVarWidthVector(name, vector, dataLength);
        if (lastOffset != dataLength) {
            this.error(name, vector, String.format("Data vector has length %d, but offset vector has largest offset %d", dataLength, lastOffset));
        }
    }

    private void validateVarDecimalVector(String name, VarDecimalVector vector) {
        int dataLength = vector.getBuffer().writerIndex();
        this.validateVarWidthVector(name, vector, dataLength);
    }

    private int validateVarWidthVector(String name, VariableWidthVector vector, int dataLength) {
        int valueCount = vector.getAccessor().getValueCount();
        return this.validateOffsetVector(name + "-offsets", vector.getOffsetVector(), valueCount, dataLength);
    }

    private void validateRepeatedVector(String name, BaseRepeatedValueVector vector) {
        ValueVector dataVector = vector.getDataVector();
        int dataLength = dataVector.getAccessor().getValueCount();
        int valueCount = vector.getAccessor().getValueCount();
        int itemCount = this.validateOffsetVector(name + "-offsets", vector.getOffsetVector(), valueCount, dataLength);
        if (dataLength != itemCount) {
            this.error(name, vector, String.format("Data vector has %d values, but offset vector has %d values", dataLength, itemCount));
        }
        this.validateVector(name + "-data", dataVector);
    }

    private void validateRepeatedBitVector(String name, RepeatedBitVector vector) {
        int valueCount = vector.getAccessor().getValueCount();
        int maxBitCount = valueCount * 8;
        int elementCount = this.validateOffsetVector(name + "-offsets", vector.getOffsetVector(), valueCount, maxBitCount);
        BitVector dataVector = vector.getDataVector();
        if (dataVector.getAccessor().getValueCount() != elementCount) {
            this.error(name, vector, String.format("Bit vector has %d values, but offset vector labels %d values", valueCount, elementCount));
        }
        this.validateBitVector(name + "-data", dataVector);
    }

    private void validateBitVector(String name, BitVector vector) {
        int expectedLength;
        BitVector.Accessor accessor = vector.getAccessor();
        int valueCount = accessor.getValueCount();
        int dataLength = vector.getBuffer().writerIndex();
        if (dataLength != (expectedLength = BitVector.getSizeFromCount(valueCount))) {
            this.error(name, vector, String.format("Bit vector has %d values, buffer has length %d, expected %d", valueCount, dataLength, expectedLength));
        }
    }

    private void validateMapVector(String name, MapVector vector) {
        int valueCount = vector.getAccessor().getValueCount();
        for (ValueVector child : vector) {
            this.validateVector(valueCount, child);
        }
    }

    private void validateRepeatedMapVector(String name, AbstractRepeatedMapVector vector) {
        int valueCount = vector.getAccessor().getValueCount();
        int elementCount = this.validateOffsetVector(name + "-offsets", vector.getOffsetVector(), valueCount, Integer.MAX_VALUE);
        for (ValueVector child : vector) {
            this.validateVector(elementCount, child);
        }
    }

    private void validateRepeatedListVector(String name, RepeatedListVector vector) {
        int valueCount = vector.getAccessor().getValueCount();
        int elementCount = this.validateOffsetVector(name + "-offsets", vector.getOffsetVector(), valueCount, Integer.MAX_VALUE);
        this.validateVector(elementCount, vector.getDataVector());
    }

    private void validateUnionVector(String name, UnionVector vector) {
        int valueCount = vector.getAccessor().getValueCount();
        MapVector internalMap = vector.getTypeMap();
        for (TypeProtos.MinorType type : vector.getSubTypes()) {
            if (type == TypeProtos.MinorType.LATE) {
                this.error(name, vector, String.format("Union vector includes illegal type LATE %s", type.name()));
                continue;
            }
            ValueVector child = internalMap.getChild(type.name());
            if (child == null) continue;
            this.validateVector(name + "-type-" + type.name(), valueCount, child);
        }
    }

    private int validateOffsetVector(String name, UInt4Vector offsetVector, int valueCount, int maxOffset) {
        int prevOffset;
        UInt4Vector.Accessor accessor = offsetVector.getAccessor();
        int offsetCount = accessor.getValueCount();
        if (valueCount == 0 && offsetCount > 1 || valueCount > 0 && offsetCount != valueCount + 1) {
            this.error(name, offsetVector, String.format("Outer vector has %d values, but offset vector has %d, expected %d", valueCount, offsetCount, valueCount + 1));
        }
        if (valueCount == 0) {
            return 0;
        }
        try {
            prevOffset = accessor.get(0);
        }
        catch (IndexOutOfBoundsException e) {
            this.error(name, offsetVector, "Offset (0) must be 0 but was undefined");
            return 0;
        }
        if (prevOffset != 0) {
            this.error(name, offsetVector, "Offset (0) must be 0 but was " + prevOffset);
        }
        for (int i = 1; i < offsetCount; ++i) {
            int offset = accessor.get(i);
            if (offset < prevOffset) {
                this.error(name, offsetVector, String.format("Offset vector [%d] contained %d, expected >= %d", i, offset, prevOffset));
            } else if (offset > maxOffset) {
                this.error(name, offsetVector, String.format("Invalid offset at index %d: %d exceeds maximum of %d", i, offset, maxOffset));
            }
            prevOffset = offset;
        }
        return prevOffset;
    }

    private void error(String name, ValueVector vector, String msg) {
        this.errorReporter.error(name, vector, msg);
    }

    private void verifyIsSetVector(ValueVector parent, UInt1Vector bv) {
        String name = String.format("%s (%s)-bits", parent.getField().getName(), parent.getClass().getSimpleName());
        int rowCount = parent.getAccessor().getValueCount();
        int bitCount = bv.getAccessor().getValueCount();
        if (bitCount != rowCount) {
            this.error(name, bv, String.format("Value count = %d, but bit count = %d", rowCount, bitCount));
        }
        UInt1Vector.Accessor ba = bv.getAccessor();
        for (int i = 0; i < bitCount; ++i) {
            byte value = ba.get(i);
            if (value == 0 || value == 1) continue;
            this.error(name, bv, String.format("Bit vector[%d] = %d, expected 0 or 1", i, (int)value));
        }
    }

    public static interface ErrorReporter {
        public void error(String var1, ValueVector var2, String var3);

        public void warn(String var1, ValueVector var2, String var3);

        public void error(String var1);

        public int errorCount();
    }

    private static class StdOutReporter
    extends BaseErrorReporter {
        public StdOutReporter(String opName) {
            super(opName);
        }

        @Override
        public void error(String msg) {
            if (this.startError()) {
                System.out.println(msg);
            }
        }

        @Override
        public void warn(String msg) {
            System.out.println(msg);
        }
    }

    private static class LogReporter
    extends BaseErrorReporter {
        public LogReporter(String opName) {
            super(opName);
        }

        @Override
        public void error(String msg) {
            if (this.startError()) {
                logger.error(msg);
            }
        }

        @Override
        public void warn(String msg) {
            logger.error(msg);
        }
    }

    public static abstract class BaseErrorReporter
    implements ErrorReporter {
        private final String opName;
        private int errorCount;

        public BaseErrorReporter(String opName) {
            this.opName = opName;
        }

        protected boolean startError() {
            if (this.errorCount == 0) {
                this.warn("Found one or more vector errors from " + this.opName);
            }
            ++this.errorCount;
            return this.errorCount < 100;
        }

        @Override
        public void error(String name, ValueVector vector, String msg) {
            this.error(String.format("%s - %s: %s", name, vector.getClass().getSimpleName(), msg));
        }

        @Override
        public void warn(String name, ValueVector vector, String msg) {
            this.warn(String.format("%s - %s: %s", name, vector.getClass().getSimpleName(), msg));
        }

        public abstract void warn(String var1);

        @Override
        public int errorCount() {
            return this.errorCount;
        }
    }
}

